/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchervisitors;

import org.parboiled.matchers.ActionMatcher;
import org.parboiled.matchers.AnyMatcher;
import org.parboiled.matchers.AnyOfMatcher;
import org.parboiled.matchers.CharIgnoreCaseMatcher;
import org.parboiled.matchers.CharMatcher;
import org.parboiled.matchers.CharRangeMatcher;
import org.parboiled.matchers.CustomMatcher;
import org.parboiled.matchers.EmptyMatcher;
import org.parboiled.matchers.FirstOfMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.NothingMatcher;
import org.parboiled.matchers.OneOrMoreMatcher;
import org.parboiled.matchers.OptionalMatcher;
import org.parboiled.matchers.SequenceMatcher;
import org.parboiled.matchers.TestMatcher;
import org.parboiled.matchers.TestNotMatcher;
import org.parboiled.matchers.ZeroOrMoreMatcher;
import org.parboiled.matchervisitors.CanMatchEmptyVisitor;
import org.parboiled.matchervisitors.MatcherVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsStarterCharVisitor
implements MatcherVisitor<Boolean> {
    private final CanMatchEmptyVisitor canMatchEmptyVisitor = new CanMatchEmptyVisitor();
    private final char starterChar;

    public IsStarterCharVisitor(char starterChar) {
        this.starterChar = starterChar;
    }

    @Override
    public Boolean visit(ActionMatcher matcher) {
        return false;
    }

    @Override
    public Boolean visit(AnyMatcher matcher) {
        return this.starterChar != '\uffff';
    }

    @Override
    public Boolean visit(CharIgnoreCaseMatcher matcher) {
        return matcher.charLow == this.starterChar || matcher.charUp == this.starterChar;
    }

    @Override
    public Boolean visit(CharMatcher matcher) {
        return matcher.character == this.starterChar;
    }

    @Override
    public Boolean visit(CharRangeMatcher matcher) {
        return matcher.cLow <= this.starterChar && this.starterChar <= matcher.cHigh;
    }

    @Override
    public Boolean visit(AnyOfMatcher matcher) {
        return matcher.characters.contains(this.starterChar);
    }

    @Override
    public Boolean visit(CustomMatcher matcher) {
        return matcher.isStarterChar(this.starterChar);
    }

    @Override
    public Boolean visit(EmptyMatcher matcher) {
        return false;
    }

    @Override
    public Boolean visit(FirstOfMatcher matcher) {
        for (Matcher child : matcher.getChildren()) {
            if (!child.accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(NothingMatcher matcher) {
        return false;
    }

    @Override
    public Boolean visit(OneOrMoreMatcher matcher) {
        return matcher.subMatcher.accept(this);
    }

    @Override
    public Boolean visit(OptionalMatcher matcher) {
        return matcher.subMatcher.accept(this);
    }

    @Override
    public Boolean visit(SequenceMatcher matcher) {
        for (Matcher child : matcher.getChildren()) {
            if (child.accept(this).booleanValue()) {
                return true;
            }
            if (child.accept(this.canMatchEmptyVisitor).booleanValue()) continue;
            break;
        }
        return false;
    }

    @Override
    public Boolean visit(TestMatcher matcher) {
        return matcher.subMatcher.accept(this);
    }

    @Override
    public Boolean visit(TestNotMatcher matcher) {
        return false;
    }

    @Override
    public Boolean visit(ZeroOrMoreMatcher matcher) {
        return matcher.subMatcher.accept(this);
    }
}

