/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.trees;

import org.parboiled.common.Preconditions;
import org.parboiled.trees.MutableBinaryTreeNode;
import org.parboiled.trees.MutableTreeNode;
import org.parboiled.trees.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeUtils {
    private TreeUtils() {
    }

    public static <T extends TreeNode<T>> T getRoot(T node) {
        if (node == null) {
            return null;
        }
        if (node.getParent() != null) {
            return TreeUtils.getRoot(node.getParent());
        }
        return node;
    }

    public static <T extends MutableTreeNode<T>> void addChild(T parent, T child) {
        Preconditions.checkArgNotNull(parent, "parent");
        parent.addChild(parent.getChildren().size(), child);
    }

    public static <T extends MutableTreeNode<T>> void removeChild(T parent, T child) {
        Preconditions.checkArgNotNull(parent, "parent");
        int index = parent.getChildren().indexOf(child);
        Preconditions.checkElementIndex(index, parent.getChildren().size());
        parent.removeChild(index);
    }

    public static <N extends MutableBinaryTreeNode<N>> N toLeftAssociativity(N node) {
        Preconditions.checkArgNotNull(node, "node");
        MutableBinaryTreeNode right = (MutableBinaryTreeNode)node.right();
        if (right == null) {
            return node;
        }
        node.setRight((MutableBinaryTreeNode)((MutableBinaryTreeNode)right.left()));
        right.setLeft(node);
        return (N)right;
    }
}

