/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.trees;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.parboiled.common.Preconditions;
import org.parboiled.trees.MutableTreeNode;
import org.parboiled.trees.TreeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableTreeNodeImpl<T extends MutableTreeNode<T>>
implements MutableTreeNode<T> {
    private final List<T> children = new ArrayList<T>();
    private final List<T> childrenView = Collections.unmodifiableList(this.children);
    private T parent;

    @Override
    public T getParent() {
        return this.parent;
    }

    @Override
    public List<T> getChildren() {
        return this.childrenView;
    }

    @Override
    public void addChild(int index, T child) {
        Preconditions.checkElementIndex(index, this.children.size() + 1);
        if (child != null) {
            if (child.getParent() == this) {
                return;
            }
            if (child.getParent() != null) {
                TreeUtils.removeChild((MutableTreeNode)child.getParent(), child);
            }
        }
        this.children.add(index, child);
        MutableTreeNodeImpl.setParent(child, this);
    }

    @Override
    public void setChild(int index, T child) {
        Preconditions.checkElementIndex(index, this.children.size());
        MutableTreeNode old = (MutableTreeNode)this.children.get(index);
        if (old == child) {
            return;
        }
        MutableTreeNodeImpl.setParent(old, null);
        if (child != null && child.getParent() != this) {
            TreeUtils.removeChild((MutableTreeNode)child.getParent(), child);
        }
        this.children.set(index, child);
        MutableTreeNodeImpl.setParent(child, this);
    }

    @Override
    public T removeChild(int index) {
        Preconditions.checkElementIndex(index, this.children.size());
        MutableTreeNode removed = (MutableTreeNode)this.children.remove(index);
        MutableTreeNodeImpl.setParent(removed, null);
        return (T)removed;
    }

    private static <T extends MutableTreeNode<T>> void setParent(T node, MutableTreeNodeImpl<T> parent) {
        if (node != null) {
            ((MutableTreeNodeImpl)node).parent = parent;
        }
    }
}

