/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.common.Preconditions;
import org.parboiled.errors.GrammarException;
import org.parboiled.matchers.CustomDefaultLabelMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchervisitors.MatcherVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZeroOrMoreMatcher
extends CustomDefaultLabelMatcher<ZeroOrMoreMatcher> {
    public final Matcher subMatcher = (Matcher)this.getChildren().get(0);

    public ZeroOrMoreMatcher(Rule subRule) {
        super(Preconditions.checkArgNotNull(subRule, "subRule"), "ZeroOrMore");
    }

    public boolean match(MatcherContext context) {
        Preconditions.checkArgNotNull(context, "context");
        int lastIndex = context.getCurrentIndex();
        while (this.subMatcher.getSubContext(context).runMatcher()) {
            int currentLocation = context.getCurrentIndex();
            if (currentLocation == lastIndex) {
                throw new GrammarException("The inner rule of ZeroOrMore rule '%s' must not allow empty matches", context.getPath());
            }
            lastIndex = currentLocation;
        }
        context.createNode();
        return true;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> visitor) {
        Preconditions.checkArgNotNull(visitor, "visitor");
        return visitor.visit(this);
    }
}

