/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.parboiled.Action;
import org.parboiled.Context;
import org.parboiled.ContextAware;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.SkippableAction;
import org.parboiled.common.Preconditions;
import org.parboiled.errors.ActionError;
import org.parboiled.errors.ActionException;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionMatcher
extends AbstractMatcher {
    public final Action action;
    public final List<ContextAware> contextAwares = new ArrayList<ContextAware>();
    public final boolean skipInPredicates;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMatcher(Action action) {
        super(Preconditions.checkArgNotNull(action, "action").toString());
        this.action = action;
        boolean bl = this.skipInPredicates = action instanceof SkippableAction && ((SkippableAction)action).skipInPredicates();
        if (action.getClass().isSynthetic()) {
            return;
        }
        if (action instanceof ContextAware) {
            this.contextAwares.add((ContextAware)((Object)action));
        }
        for (Field field : action.getClass().getDeclaredFields()) {
            if (!field.isSynthetic() || !ContextAware.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                ContextAware contextAware = (ContextAware)field.get(action);
                if (contextAware == null) continue;
                this.contextAwares.add(contextAware);
            }
            catch (IllegalAccessException e) {
            }
            finally {
                field.setAccessible(false);
            }
        }
    }

    @Override
    public MatcherContext getSubContext(MatcherContext context) {
        MatcherContext subContext = context.getBasicSubContext();
        subContext.setMatcher(this);
        return subContext.getCurrentIndex() > 0 ? subContext : context.getSubContext(this);
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        if (this.skipInPredicates && context.inPredicate()) {
            return true;
        }
        Context parentContext = context.getParent();
        if (!this.contextAwares.isEmpty()) {
            for (ContextAware contextAware : this.contextAwares) {
                contextAware.setContext(parentContext);
            }
        }
        try {
            Object valueStackSnapshot = context.getValueStack().takeSnapshot();
            if (!this.action.run(parentContext)) {
                context.getValueStack().restoreSnapshot(valueStackSnapshot);
                return false;
            }
            context.setCurrentIndex(((MatcherContext)parentContext).getCurrentIndex());
            return true;
        }
        catch (ActionException e) {
            context.getParseErrors().add(new ActionError(context.getInputBuffer(), context.getCurrentIndex(), e.getMessage(), context.getPath(), e));
            return false;
        }
    }

    @Override
    public Rule suppressNode() {
        return this;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> visitor) {
        Preconditions.checkArgNotNull(visitor, "visitor");
        return visitor.visit(this);
    }
}

