/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled;

import java.util.List;
import org.parboiled.Context;
import org.parboiled.MatchHandler;
import org.parboiled.Node;
import org.parboiled.NodeImpl;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.ImmutableLinkedList;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.errors.BasicParseError;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.errors.GrammarException;
import org.parboiled.errors.ParseError;
import org.parboiled.errors.ParserRuntimeException;
import org.parboiled.matchers.ActionMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.MatcherUtils;
import org.parboiled.matchers.ProxyMatcher;
import org.parboiled.matchers.SequenceMatcher;
import org.parboiled.matchers.TestMatcher;
import org.parboiled.matchers.TestNotMatcher;
import org.parboiled.support.Checks;
import org.parboiled.support.IndexRange;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.ParseTreeUtils;
import org.parboiled.support.ValueStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatcherContext<V>
implements Context<V> {
    private final InputBuffer inputBuffer;
    private final ValueStack<V> valueStack;
    private final List<ParseError> parseErrors;
    private final MatchHandler matchHandler;
    private final MatcherContext<V> parent;
    private final int level;
    private final boolean fastStringMatching;
    private MatcherContext<V> subContext;
    private int startIndex;
    private int currentIndex;
    private char currentChar;
    private Matcher matcher;
    private Node<V> node;
    private ImmutableLinkedList<Node<V>> subNodes = ImmutableLinkedList.nil();
    private MatcherPath path;
    private int intTag;
    private boolean hasError;
    private boolean nodeSuppressed;
    private boolean inErrorRecovery;

    public MatcherContext(InputBuffer inputBuffer, ValueStack<V> valueStack, List<ParseError> parseErrors, MatchHandler matchHandler, Matcher matcher, boolean fastStringMatching) {
        this(Preconditions.checkArgNotNull(inputBuffer, "inputBuffer"), Preconditions.checkArgNotNull(valueStack, "valueStack"), Preconditions.checkArgNotNull(parseErrors, "parseErrors"), Preconditions.checkArgNotNull(matchHandler, "matchHandler"), null, 0, fastStringMatching);
        this.currentChar = inputBuffer.charAt(0);
        this.matcher = ProxyMatcher.unwrap(Preconditions.checkArgNotNull(matcher, "matcher"));
        this.nodeSuppressed = matcher.isNodeSuppressed();
    }

    private MatcherContext(InputBuffer inputBuffer, ValueStack<V> valueStack, List<ParseError> parseErrors, MatchHandler matchHandler, MatcherContext<V> parent, int level, boolean fastStringMatching) {
        this.inputBuffer = inputBuffer;
        this.valueStack = valueStack;
        this.parseErrors = parseErrors;
        this.matchHandler = matchHandler;
        this.parent = parent;
        this.level = level;
        this.fastStringMatching = fastStringMatching;
    }

    public String toString() {
        return this.getPath().toString();
    }

    @Override
    public MatcherContext<V> getParent() {
        return this.parent;
    }

    @Override
    public InputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public Matcher getMatcher() {
        return this.matcher;
    }

    @Override
    public char getCurrentChar() {
        return this.currentChar;
    }

    @Override
    public List<ParseError> getParseErrors() {
        return this.parseErrors;
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public MatcherPath getPath() {
        if (this.path == null) {
            this.path = new MatcherPath(new MatcherPath.Element(this.matcher, this.startIndex, this.level), this.parent != null ? this.parent.getPath() : null);
        }
        return this.path;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public boolean fastStringMatching() {
        return this.fastStringMatching;
    }

    @Override
    public List<Node<V>> getSubNodes() {
        return this.subNodes.reverse();
    }

    @Override
    public boolean inPredicate() {
        return this.matcher instanceof TestMatcher || this.matcher instanceof TestNotMatcher || this.parent != null && this.parent.inPredicate();
    }

    @Override
    public boolean inErrorRecovery() {
        return this.inErrorRecovery;
    }

    @Override
    public boolean isNodeSuppressed() {
        return this.nodeSuppressed;
    }

    @Override
    public boolean hasError() {
        return this.hasError;
    }

    @Override
    public String getMatch() {
        this.checkActionContext();
        MatcherContext<V> prevContext = this.subContext;
        if (this.hasError) {
            Node<V> prevNode = prevContext.node;
            return prevNode != null ? ParseTreeUtils.getNodeText(prevNode, this.inputBuffer) : "";
        }
        return this.inputBuffer.extract(prevContext.startIndex, prevContext.currentIndex);
    }

    @Override
    public char getFirstMatchChar() {
        this.checkActionContext();
        int ix = this.subContext.startIndex;
        if (this.subContext.currentIndex <= ix) {
            throw new GrammarException("getFirstMatchChar called but previous rule did not match anything");
        }
        return this.inputBuffer.charAt(ix);
    }

    @Override
    public int getMatchStartIndex() {
        this.checkActionContext();
        return this.subContext.startIndex;
    }

    @Override
    public int getMatchEndIndex() {
        this.checkActionContext();
        return this.subContext.currentIndex;
    }

    @Override
    public int getMatchLength() {
        this.checkActionContext();
        return this.subContext.currentIndex - this.subContext.getStartIndex();
    }

    @Override
    public IndexRange getMatchRange() {
        this.checkActionContext();
        return new IndexRange(this.subContext.startIndex, this.subContext.currentIndex);
    }

    private void checkActionContext() {
        Checks.ensure(MatcherUtils.unwrap(this.matcher) instanceof SequenceMatcher && this.intTag > 0 && this.subContext.matcher instanceof ActionMatcher, "Illegal call to getMatch(), getMatchStartIndex(), getMatchEndIndex() or getMatchRange(), only valid in Sequence rule actions that are not in first position");
    }

    @Override
    public ValueStack<V> getValueStack() {
        return this.valueStack;
    }

    public void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    public void setStartIndex(int startIndex) {
        Preconditions.checkArgument(startIndex >= 0);
        this.startIndex = startIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        Preconditions.checkArgument(currentIndex >= 0);
        this.currentIndex = currentIndex;
        this.currentChar = this.inputBuffer.charAt(currentIndex);
    }

    public void setInErrorRecovery(boolean flag) {
        this.inErrorRecovery = flag;
    }

    public void advanceIndex(int delta) {
        this.currentIndex += delta;
        this.currentChar = this.inputBuffer.charAt(this.currentIndex);
    }

    public Node<V> getNode() {
        return this.node;
    }

    public int getIntTag() {
        return this.intTag;
    }

    public void setIntTag(int intTag) {
        this.intTag = intTag;
    }

    public void markError() {
        if (!this.hasError) {
            this.hasError = true;
            if (this.parent != null) {
                this.parent.markError();
            }
        }
    }

    public void createNode() {
        if (!this.nodeSuppressed && !this.matcher.isNodeSkipped()) {
            this.node = new NodeImpl<Object>(this.matcher, (List<Node<Object>>)this.getSubNodes(), this.startIndex, this.currentIndex, (this.valueStack.isEmpty() ? null : (Object)this.valueStack.peek()), this.hasError);
            Context<V> nodeParentContext = this.parent;
            if (nodeParentContext != null) {
                while (nodeParentContext.getMatcher().isNodeSkipped()) {
                    Checks.ensure((nodeParentContext = nodeParentContext.getParent()) != null, "Root rule must not be marked @SkipNode");
                }
                nodeParentContext.subNodes = nodeParentContext.subNodes.prepend(this.node);
            }
        }
    }

    public final MatcherContext<V> getBasicSubContext() {
        if (this.subContext == null) {
            this.subContext = new MatcherContext<V>(this.inputBuffer, this.valueStack, this.parseErrors, this.matchHandler, this, this.level + 1, this.fastStringMatching);
        } else {
            this.subContext.path = null;
        }
        return this.subContext;
    }

    public final MatcherContext<V> getSubContext(Matcher matcher) {
        MatcherContext<V> sc = this.getBasicSubContext();
        sc.matcher = matcher;
        sc.startIndex = sc.currentIndex = this.currentIndex;
        sc.currentChar = this.currentChar;
        sc.node = null;
        sc.subNodes = ImmutableLinkedList.nil();
        sc.nodeSuppressed = this.nodeSuppressed || this.matcher.areSubnodesSuppressed() || matcher.isNodeSuppressed();
        sc.hasError = false;
        return sc;
    }

    public boolean runMatcher() {
        try {
            if (this.matchHandler.match(this)) {
                if (this.parent != null) {
                    this.parent.currentIndex = this.currentIndex;
                    this.parent.currentChar = this.currentChar;
                }
                this.matcher = null;
                return true;
            }
            this.matcher = null;
            return false;
        }
        catch (ParserRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ParserRuntimeException(e, ErrorUtils.printParseError(new BasicParseError(this.inputBuffer, this.currentIndex, StringUtils.escape(String.format("Error while parsing %s '%s' at input position", this.matcher instanceof ActionMatcher ? "action" : "rule", this.getPath())))) + '\n' + e, new Object[0]);
        }
    }
}

