/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import org.parboiled.MatcherContext;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharMatcher
extends AbstractMatcher {
    public final char character;

    public CharMatcher(char character) {
        super(CharMatcher.getLabel(character));
        this.character = character;
    }

    private static String getLabel(char c) {
        switch (c) {
            case '\ufdd0': 
            case '\ufdd1': 
            case '\ufded': 
            case '\ufdee': 
            case '\ufdef': 
            case '\uffff': {
                return StringUtils.escape(c);
            }
        }
        return '\'' + StringUtils.escape(c) + '\'';
    }

    public boolean match(MatcherContext context) {
        if (context.getCurrentChar() != this.character) {
            return false;
        }
        context.advanceIndex(1);
        context.createNode();
        return true;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> visitor) {
        Preconditions.checkArgNotNull(visitor, "visitor");
        return visitor.visit(this);
    }
}

