/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import java.util.HashSet;
import java.util.Set;
import org.parboiled.Context;
import org.parboiled.Node;
import org.parboiled.Rule;
import org.parboiled.common.Predicate;
import org.parboiled.common.Predicates;
import org.parboiled.common.Tuple2;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.ProxyMatcher;
import org.parboiled.support.MatcherPath;
import org.parboiled.trees.GraphUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filters {
    public static final Predicate<Node<Object>> SKIP_EMPTY_OPTS = new Predicate<Node<Object>>(){

        @Override
        public boolean apply(Node<Object> node) {
            return GraphUtils.hasChildren(node) || node.getEndIndex() != node.getStartIndex() || !"Optional".equals(node.getLabel());
        }
    };
    public static final Predicate<Node<Object>> SKIP_EMPTY_ZOMS = new Predicate<Node<Object>>(){

        @Override
        public boolean apply(Node<Object> node) {
            return GraphUtils.hasChildren(node) || node.getEndIndex() != node.getStartIndex() || !"ZeroOrMore".equals(node.getLabel());
        }
    };
    public static final Predicate<Node<Object>> SKIP_EMPTY_OPTS_AND_ZOMS = Predicates.and(SKIP_EMPTY_OPTS, SKIP_EMPTY_ZOMS);

    public static Predicate<Matcher> preventLoops() {
        return new Predicate<Matcher>(){
            private final Set<Matcher> visited = new HashSet<Matcher>();

            @Override
            public boolean apply(Matcher node) {
                if (this.visited.contains(node = ProxyMatcher.unwrap(node))) {
                    return false;
                }
                this.visited.add(node);
                return true;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> lines(final int firstLine, final int lastLine) {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> tuple) {
                int line = ((Context)tuple.a).getInputBuffer().getPosition((int)((Context)tuple.a).getCurrentIndex()).line;
                return firstLine <= line && line <= lastLine;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> fromLine(final int firstLine) {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> tuple) {
                return ((Context)tuple.a).getInputBuffer().getPosition((int)((Context)tuple.a).getCurrentIndex()).line >= firstLine;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> untilLine(final int lastLine) {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> tuple) {
                return ((Context)tuple.a).getInputBuffer().getPosition((int)((Context)tuple.a).getCurrentIndex()).line <= lastLine;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> rules(final Rule ... rules) {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> tuple) {
                MatcherPath path = ((Context)tuple.a).getPath();
                for (Rule rule : rules) {
                    if (!path.contains((Matcher)rule)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> onlyRules(final Rule ... rules) {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> tuple) {
                for (Rule rule : rules) {
                    if (((Context)tuple.a).getMatcher() != rule) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> rulesBelow(final Rule ... rules) {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> tuple) {
                MatcherPath path = ((Context)tuple.a).getPath();
                for (Rule rule : rules) {
                    Matcher matcher = (Matcher)rule;
                    if (((Context)tuple.a).getMatcher() == matcher || !path.contains(matcher)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> onlyMatches() {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> tuple) {
                return (Boolean)tuple.b;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> onlyMismatches() {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> tuple) {
                return (Boolean)tuple.b == false;
            }
        };
    }
}

