/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import org.parboiled.Context;
import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Predicate;
import org.parboiled.common.Predicates;
import org.parboiled.common.Tuple2;
import org.parboiled.matchers.Matcher;
import org.parboiled.parserunners.BasicParseRunner;
import org.parboiled.parserunners.RecordingParseRunner;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.MatcherPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracingParseRunner<V>
extends BasicParseRunner<V> {
    private final StringBuilder log = new StringBuilder();
    private final Predicate<Tuple2<Context<?>, Boolean>> filter;

    public TracingParseRunner(Rule rule) {
        this(Preconditions.checkArgNotNull(rule, "rule"), Predicates.alwaysTrue());
    }

    public TracingParseRunner(Rule rule, Predicate<?> filter) {
        super(Preconditions.checkArgNotNull(rule, "rule"));
        this.filter = Preconditions.checkArgNotNull(filter, "filter");
    }

    public String getLog() {
        return this.log.toString();
    }

    @Override
    protected boolean runRootContext() {
        if (this.runRootContext(new Handler(this.log, this.filter), true)) {
            return true;
        }
        RecordingParseRunner.Handler recordingHandler = new RecordingParseRunner.Handler();
        if (this.runRootContext(recordingHandler, false)) {
            throw new IllegalStateException();
        }
        ReportingParseRunner.Handler reportingHandler = new ReportingParseRunner.Handler(recordingHandler.getErrorIndex());
        if (this.runRootContext(reportingHandler, false)) {
            throw new IllegalStateException();
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Handler
    implements MatchHandler {
        private final StringBuilder log;
        private final Predicate<Tuple2<Context<?>, Boolean>> filter;
        private MatcherPath lastPath;

        public Handler(StringBuilder log, Predicate<Tuple2<Context<?>, Boolean>> filter) {
            this.log = log;
            this.filter = filter;
        }

        @Override
        public boolean matchRoot(MatcherContext<?> rootContext) {
            this.log.setLength(0);
            this.lastPath = null;
            return rootContext.runMatcher();
        }

        @Override
        public boolean match(MatcherContext<?> context) {
            Matcher matcher = context.getMatcher();
            boolean matched = matcher.match(context);
            if (this.filter.apply(new Tuple2(context, matched))) {
                this.print(context, matched);
            }
            return matched;
        }

        private void print(MatcherContext<?> context, boolean matched) {
            MatcherPath prefix;
            InputBuffer.Position pos = context.getInputBuffer().getPosition(context.getCurrentIndex());
            MatcherPath path = context.getPath();
            MatcherPath matcherPath = prefix = this.lastPath != null ? path.commonPrefix(this.lastPath) : null;
            if (prefix != null && prefix.length() > 1) {
                this.log.append("..(").append(prefix.length() - 1).append(")../");
            }
            this.log.append(path.toString(prefix != null ? prefix.parent : null));
            String line = context.getInputBuffer().extractLine(pos.line);
            this.log.append(", ").append(matched ? "matched" : "failed").append(", cursor at ").append(pos.line).append(':').append(pos.column).append(" after \"").append(line.substring(0, Math.min(line.length(), pos.column - 1))).append("\"\n");
            this.lastPath = path;
        }
    }
}

