/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import java.util.ArrayList;
import java.util.List;
import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.common.Preconditions;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.matchervisitors.IsSingleCharMatcherVisitor;
import org.parboiled.parserunners.BasicParseRunner;
import org.parboiled.parserunners.RecordingParseRunner;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.ParsingResult;
import org.parboiled.support.ValueStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportingParseRunner<V>
extends BasicParseRunner<V> {
    public static <V> ParsingResult<V> run(Rule rule, String input) {
        Preconditions.checkArgNotNull(rule, "rule");
        Preconditions.checkArgNotNull(input, "input");
        return new ReportingParseRunner<V>(rule).run(input);
    }

    public ReportingParseRunner(Rule rule) {
        super(Preconditions.checkArgNotNull(rule, "rule"));
    }

    public ReportingParseRunner(Rule rule, ValueStack<V> valueStack) {
        super(Preconditions.checkArgNotNull(rule, "rule"), Preconditions.checkArgNotNull(valueStack, "valueStack"));
    }

    @Override
    protected boolean runRootContext() {
        if (super.runRootContext()) {
            return true;
        }
        RecordingParseRunner.Handler recordingHandler = new RecordingParseRunner.Handler();
        if (this.runRootContext(recordingHandler, false)) {
            throw new IllegalStateException();
        }
        Handler reportingHandler = new Handler(recordingHandler.getErrorIndex());
        if (this.runRootContext(reportingHandler, false)) {
            throw new IllegalStateException();
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Handler
    implements MatchHandler {
        private final IsSingleCharMatcherVisitor isSingleCharMatcherVisitor = new IsSingleCharMatcherVisitor();
        private final int errorIndex;
        private final MatchHandler inner;
        private final List<MatcherPath> failedMatchers = new ArrayList<MatcherPath>();
        private InvalidInputError parseError;
        private boolean seeking;

        public Handler(int errorIndex) {
            this(errorIndex, new BasicParseRunner.Handler());
        }

        public Handler(int errorIndex, MatchHandler inner) {
            this.errorIndex = errorIndex;
            this.inner = Preconditions.checkArgNotNull(inner, "inner");
        }

        public InvalidInputError getParseError() {
            return this.parseError;
        }

        @Override
        public boolean matchRoot(MatcherContext<?> rootContext) {
            this.failedMatchers.clear();
            this.seeking = this.errorIndex > 0;
            this.inner.matchRoot(rootContext);
            this.parseError = new InvalidInputError(rootContext.getInputBuffer(), this.errorIndex, this.failedMatchers, null);
            rootContext.getParseErrors().add(this.parseError);
            return false;
        }

        @Override
        public boolean match(MatcherContext<?> context) {
            boolean matched = this.inner.match(context);
            if (context.getCurrentIndex() == this.errorIndex) {
                if (matched && this.seeking) {
                    this.seeking = false;
                }
                if (!matched && !this.seeking && context.getMatcher().accept(this.isSingleCharMatcherVisitor).booleanValue()) {
                    this.failedMatchers.add(context.getPath());
                }
            }
            return matched;
        }
    }
}

