/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.MutableInputBuffer;
import org.parboiled.common.Preconditions;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchers.ActionMatcher;
import org.parboiled.matchers.EmptyMatcher;
import org.parboiled.matchers.FirstOfMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.OneOrMoreMatcher;
import org.parboiled.matchers.SequenceMatcher;
import org.parboiled.matchers.TestMatcher;
import org.parboiled.matchervisitors.DefaultMatcherVisitor;
import org.parboiled.matchervisitors.FollowMatchersVisitor;
import org.parboiled.matchervisitors.GetStarterCharVisitor;
import org.parboiled.matchervisitors.IsSingleCharMatcherVisitor;
import org.parboiled.matchervisitors.IsStarterCharVisitor;
import org.parboiled.parserunners.BasicParseRunner;
import org.parboiled.parserunners.RecordingParseRunner;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.ParsingResult;
import org.parboiled.support.ValueStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecoveringParseRunner<V>
extends BasicParseRunner<V> {
    private int errorIndex;
    private InvalidInputError currentError;
    private MutableInputBuffer buffer;

    public static <V> ParsingResult<V> run(Rule rule, String input) {
        Preconditions.checkArgNotNull(rule, "rule");
        Preconditions.checkArgNotNull(input, "input");
        return new RecoveringParseRunner<V>(rule).run(input);
    }

    public RecoveringParseRunner(Rule rule) {
        super(Preconditions.checkArgNotNull(rule, "rule"));
    }

    public RecoveringParseRunner(Rule rule, ValueStack<V> valueStack) {
        super(Preconditions.checkArgNotNull(rule, "rule"), Preconditions.checkArgNotNull(valueStack, "valueStack"));
    }

    @Override
    protected boolean runRootContext() {
        if (super.runRootContext()) {
            return true;
        }
        if (this.attemptRecordingMatch()) {
            throw new IllegalStateException();
        }
        this.buffer = new MutableInputBuffer(this.inputBuffer);
        this.inputBuffer = this.buffer;
        do {
            this.performErrorReportingRun();
        } while (!this.fixError(this.errorIndex));
        return true;
    }

    protected boolean attemptRecordingMatch() {
        RecordingParseRunner.Handler handler = new RecordingParseRunner.Handler(this.getInnerHandler());
        boolean matched = this.runRootContext(handler, false);
        this.errorIndex = handler.getErrorIndex();
        return matched;
    }

    protected void performErrorReportingRun() {
        ReportingParseRunner.Handler handler = new ReportingParseRunner.Handler(this.errorIndex, this.getInnerHandler());
        if (this.runRootContext(handler, false)) {
            throw new IllegalStateException();
        }
        this.currentError = handler.getParseError();
    }

    protected MatchHandler getInnerHandler() {
        return this.errorIndex >= 0 ? new Handler(this.currentError) : new BasicParseRunner.Handler();
    }

    protected boolean fixError(int fixIndex) {
        if (this.tryFixBySingleCharDeletion(fixIndex)) {
            return true;
        }
        int nextErrorAfterDeletion = this.errorIndex;
        Character bestInsertionCharacter = this.findBestSingleCharInsertion(fixIndex);
        if (bestInsertionCharacter == null) {
            return true;
        }
        int nextErrorAfterBestInsertion = this.errorIndex;
        Character bestReplacementCharacter = this.findBestSingleCharReplacement(fixIndex);
        if (bestReplacementCharacter == null) {
            return true;
        }
        int nextErrorAfterBestReplacement = this.errorIndex;
        int nextErrorAfterBestSingleCharFix = Math.max(Math.max(nextErrorAfterDeletion, nextErrorAfterBestInsertion), nextErrorAfterBestReplacement);
        if (nextErrorAfterBestSingleCharFix > fixIndex) {
            if (nextErrorAfterBestSingleCharFix == nextErrorAfterDeletion) {
                this.buffer.insertChar(fixIndex, '\ufdef');
                this.errorIndex = nextErrorAfterDeletion + 1;
                this.currentError.shiftIndexDeltaBy(1);
            } else if (nextErrorAfterBestSingleCharFix == nextErrorAfterBestInsertion) {
                this.buffer.insertChar(fixIndex, bestInsertionCharacter.charValue());
                this.buffer.insertChar(fixIndex, '\ufdee');
                this.errorIndex = nextErrorAfterBestInsertion + 2;
                this.currentError.shiftIndexDeltaBy(2);
            } else {
                this.buffer.insertChar(fixIndex + 1, bestReplacementCharacter.charValue());
                this.buffer.insertChar(fixIndex + 1, '\ufdee');
                this.buffer.insertChar(fixIndex, '\ufdef');
                this.errorIndex = nextErrorAfterBestReplacement + 5;
                this.currentError.shiftIndexDeltaBy(1);
            }
        } else {
            if (this.buffer.charAt(fixIndex) == '\uffff') {
                return true;
            }
            this.buffer.insertChar(fixIndex, '\ufded');
            this.currentError.shiftIndexDeltaBy(1);
            this.attemptRecordingMatch();
        }
        return this.errorIndex == -1;
    }

    protected boolean tryFixBySingleCharDeletion(int fixIndex) {
        this.buffer.insertChar(fixIndex, '\ufdef');
        boolean nowErrorFree = this.attemptRecordingMatch();
        if (nowErrorFree) {
            this.currentError.shiftIndexDeltaBy(1);
        } else {
            this.buffer.undoCharInsertion(fixIndex);
            this.errorIndex = Math.max(this.errorIndex - 1, 0);
        }
        return nowErrorFree;
    }

    protected Character findBestSingleCharInsertion(int fixIndex) {
        GetStarterCharVisitor getStarterCharVisitor = new GetStarterCharVisitor();
        int bestNextErrorIndex = -1;
        Character bestChar = null;
        for (MatcherPath failedMatcherPath : this.currentError.getFailedMatchers()) {
            Character starterChar = failedMatcherPath.element.matcher.accept(getStarterCharVisitor);
            Preconditions.checkState(starterChar != null);
            if (starterChar.charValue() == '\uffff') continue;
            this.buffer.insertChar(fixIndex, starterChar.charValue());
            this.buffer.insertChar(fixIndex, '\ufdee');
            if (this.attemptRecordingMatch()) {
                this.currentError.shiftIndexDeltaBy(2);
                return null;
            }
            this.buffer.undoCharInsertion(fixIndex);
            this.buffer.undoCharInsertion(fixIndex);
            this.errorIndex = Math.max(this.errorIndex - 2, 0);
            if (bestNextErrorIndex >= this.errorIndex) continue;
            bestNextErrorIndex = this.errorIndex;
            bestChar = starterChar;
        }
        this.errorIndex = bestNextErrorIndex;
        return bestChar;
    }

    protected Character findBestSingleCharReplacement(int fixIndex) {
        this.buffer.insertChar(fixIndex, '\ufdef');
        Character bestChar = this.findBestSingleCharInsertion(fixIndex + 2);
        if (bestChar == null) {
            this.currentError.shiftIndexDeltaBy(-1);
        } else {
            this.buffer.undoCharInsertion(fixIndex);
            this.errorIndex = Math.max(this.errorIndex - 3, 0);
        }
        return bestChar;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollectResyncActionsVisitor
    extends DefaultMatcherVisitor<List<ActionMatcher>> {
        private final Set<Matcher> visited = new HashSet<Matcher>();
        private final List<ActionMatcher> actions = new ArrayList<ActionMatcher>();

        private CollectResyncActionsVisitor() {
        }

        @Override
        public List<ActionMatcher> visit(ActionMatcher matcher) {
            this.actions.add(matcher);
            return this.actions;
        }

        @Override
        public List<ActionMatcher> visit(FirstOfMatcher matcher) {
            List children = matcher.getChildren();
            for (int i = children.size() - 1; i >= 0; --i) {
                if (((Matcher)children.get(i)).accept(this) == null) continue;
                return this.actions;
            }
            throw new IllegalStateException();
        }

        @Override
        public List<ActionMatcher> visit(OneOrMoreMatcher matcher) {
            return matcher.subMatcher.accept(this);
        }

        @Override
        public List<ActionMatcher> visit(SequenceMatcher matcher) {
            if (this.visited.contains(matcher)) {
                return null;
            }
            this.visited.add(matcher);
            for (Matcher sub : matcher.getChildren()) {
                sub.accept(this);
            }
            return this.actions;
        }

        @Override
        public List<ActionMatcher> defaultValue(AbstractMatcher matcher) {
            return this.actions;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Handler
    implements MatchHandler {
        private final IsSingleCharMatcherVisitor isSingleCharMatcherVisitor = new IsSingleCharMatcherVisitor();
        private final InvalidInputError currentError;
        private int fringeIndex;
        private MatcherPath lastMatchPath;

        public Handler(InvalidInputError currentError) {
            this.currentError = currentError;
        }

        @Override
        public boolean matchRoot(MatcherContext<?> rootContext) {
            return rootContext.runMatcher();
        }

        @Override
        public boolean match(MatcherContext<?> context) {
            Matcher matcher = context.getMatcher();
            if (matcher.accept(this.isSingleCharMatcherVisitor).booleanValue()) {
                if (this.prepareErrorLocation(context) && matcher.match(context)) {
                    if (this.fringeIndex < context.getCurrentIndex()) {
                        this.fringeIndex = context.getCurrentIndex();
                        this.lastMatchPath = context.getPath();
                    }
                    return true;
                }
                return false;
            }
            if (matcher.match(context)) {
                return true;
            }
            return context.getInputBuffer().charAt(this.fringeIndex) == '\ufded' && this.qualifiesForResync(context, matcher) && this.resynchronize(context);
        }

        private boolean qualifiesForResync(MatcherContext context, Matcher matcher) {
            if (matcher instanceof SequenceMatcher && context.getCurrentIndex() > context.getStartIndex() && context.getPath().isPrefixOf(this.lastMatchPath)) {
                return true;
            }
            return context.getParent() == null;
        }

        protected boolean prepareErrorLocation(MatcherContext context) {
            switch (context.getCurrentChar()) {
                case '\ufdef': {
                    return this.willMatchDelError(context);
                }
                case '\ufdee': {
                    return this.willMatchInsError(context);
                }
            }
            return true;
        }

        protected boolean willMatchDelError(MatcherContext context) {
            int preSkipIndex = context.getCurrentIndex();
            context.advanceIndex(2);
            if (!this.runTestMatch(context)) {
                context.setCurrentIndex(preSkipIndex);
                return false;
            }
            context.setStartIndex(context.getCurrentIndex());
            context.clearNodeSuppression();
            if (context.getParent() != null) {
                ((MatcherContext)context.getParent()).markError();
            }
            return true;
        }

        protected boolean willMatchInsError(MatcherContext context) {
            int preSkipIndex = context.getCurrentIndex();
            context.advanceIndex(1);
            if (!this.runTestMatch(context)) {
                context.setCurrentIndex(preSkipIndex);
                return false;
            }
            context.setStartIndex(context.getCurrentIndex());
            context.clearNodeSuppression();
            context.markError();
            return true;
        }

        protected boolean runTestMatch(MatcherContext context) {
            TestMatcher testMatcher = new TestMatcher(context.getMatcher());
            MatcherContext testContext = testMatcher.getSubContext(context);
            return this.prepareErrorLocation(testContext) && testContext.runMatcher();
        }

        protected boolean resynchronize(MatcherContext context) {
            context.clearNodeSuppression();
            context.markError();
            context.createNode();
            this.executeErrorActions(context);
            context.advanceIndex(1);
            ++this.fringeIndex;
            List<Matcher> followMatchers = new FollowMatchersVisitor().getFollowMatchers(context);
            int endIndex = this.gobbleIllegalCharacters(context, followMatchers);
            if (this.currentError != null && this.currentError.getStartIndex() == this.fringeIndex && endIndex - this.fringeIndex > 1) {
                this.currentError.setEndIndex(endIndex);
            }
            return true;
        }

        private void executeErrorActions(MatcherContext context) {
            context.setCurrentIndex(context.getStartIndex());
            Matcher lastGoodSub = this.lastMatchPath == null ? null : this.lastMatchPath.getElementAtLevel((int)(context.getLevel() + 1)).matcher;
            boolean errorMode = false;
            for (Matcher sub : context.getMatcher().getChildren()) {
                if (errorMode) {
                    for (ActionMatcher action : sub.accept(new CollectResyncActionsVisitor())) {
                        action.getSubContext(context).runMatcher();
                    }
                    continue;
                }
                sub.getSubContext(context).runMatcher();
                if (sub != lastGoodSub) continue;
                context.getSubContext(new EmptyMatcher()).runMatcher();
                errorMode = true;
            }
        }

        protected int gobbleIllegalCharacters(MatcherContext context, List<Matcher> followMatchers) {
            char currentChar;
            block0: while ((currentChar = context.getCurrentChar()) != '\uffff') {
                for (Matcher followMatcher : followMatchers) {
                    if (!followMatcher.accept(new IsStarterCharVisitor(currentChar)).booleanValue()) continue;
                    break block0;
                }
                context.advanceIndex(1);
            }
            return context.getCurrentIndex();
        }
    }
}

