/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.common.Preconditions;
import org.parboiled.matchers.TestNotMatcher;
import org.parboiled.parserunners.BasicParseRunner;
import org.parboiled.support.ParsingResult;
import org.parboiled.support.ValueStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordingParseRunner<V>
extends BasicParseRunner<V> {
    private Handler handler;

    public static <V> ParsingResult<V> run(Rule rule, String input) {
        Preconditions.checkArgNotNull(rule, "rule");
        Preconditions.checkArgNotNull(input, "input");
        return new RecordingParseRunner<V>(rule).run(input);
    }

    public RecordingParseRunner(Rule rule) {
        super(Preconditions.checkArgNotNull(rule, "rule"));
    }

    public RecordingParseRunner(Rule rule, ValueStack<V> valueStack) {
        super(Preconditions.checkArgNotNull(rule, "rule"), Preconditions.checkArgNotNull(valueStack, "valueStack"));
    }

    @Override
    protected boolean runRootContext() {
        this.handler = new Handler();
        return this.runRootContext(this.handler, false);
    }

    public int getErrorIndex() {
        Preconditions.checkState(this.handler != null, "getErrorIndex() called before run()");
        return this.handler.getErrorIndex();
    }

    public static class Handler
    implements MatchHandler {
        private int errorIndex;
        private final MatchHandler inner;

        public Handler() {
            this(new BasicParseRunner.Handler());
        }

        public Handler(MatchHandler inner) {
            this.inner = Preconditions.checkArgNotNull(inner, "inner");
        }

        public int getErrorIndex() {
            return this.errorIndex;
        }

        public boolean matchRoot(MatcherContext rootContext) {
            this.errorIndex = rootContext.getCurrentIndex();
            if (this.inner.matchRoot(rootContext)) {
                this.errorIndex = -1;
                return true;
            }
            return false;
        }

        public boolean match(MatcherContext context) {
            if (this.inner.match(context)) {
                if (this.errorIndex < context.getCurrentIndex() && this.notTestNot(context)) {
                    this.errorIndex = context.getCurrentIndex();
                }
                return true;
            }
            return false;
        }

        private boolean notTestNot(MatcherContext context) {
            return !(context.getMatcher() instanceof TestNotMatcher) && (context.getParent() == null || this.notTestNot((MatcherContext)context.getParent()));
        }
    }
}

