/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Predicate;
import org.parboiled.common.StringUtils;
import org.parboiled.common.Utils;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchervisitors.DoWithMatcherVisitor;
import org.parboiled.parserunners.BasicParseRunner;
import org.parboiled.support.ValueStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilingParseRunner<V>
extends BasicParseRunner<V> {
    private final Map<Rule, RuleReport> ruleReports = new HashMap<Rule, RuleReport>();
    private int totalRuns;
    private int totalMatches;
    private int totalMismatches;
    private int totalRematches;
    private int totalRemismatches;
    private long totalNanoTime;
    private final DoWithMatcherVisitor.Action updateStatsAction = new DoWithMatcherVisitor.Action(){

        public void process(Matcher matcher) {
            RuleStats ruleStats = (RuleStats)matcher.getTag();
            int rematches = 0;
            int remismatches = 0;
            for (Integer i : ruleStats.positionMatches.values()) {
                if (i > 0) {
                    rematches += i - 1;
                    continue;
                }
                if (i >= 0) continue;
                remismatches += -(i + 1);
            }
            ProfilingParseRunner.this.totalMatches += ruleStats.matches;
            ProfilingParseRunner.this.totalMismatches += ruleStats.mismatches;
            ProfilingParseRunner.this.totalRematches += rematches;
            ProfilingParseRunner.this.totalRemismatches += remismatches;
            RuleReport ruleReport = (RuleReport)ProfilingParseRunner.this.ruleReports.get(matcher);
            if (ruleReport == null) {
                ruleReport = new RuleReport(matcher);
                ProfilingParseRunner.this.ruleReports.put(matcher, ruleReport);
            }
            ruleReport.update(ruleStats.matches, ruleStats.matchSubs, ruleStats.mismatches, ruleStats.mismatchSubs, rematches, ruleStats.rematchSubs, remismatches, ruleStats.remismatchSubs, ruleStats.nanoTime);
        }
    };

    public ProfilingParseRunner(Rule rule) {
        super(Preconditions.checkArgNotNull(rule, "rule"));
    }

    public ProfilingParseRunner(Rule rule, ValueStack<V> valueStack) {
        super(Preconditions.checkArgNotNull(rule, "rule"), Preconditions.checkArgNotNull(valueStack, "valueStack"));
    }

    @Override
    protected boolean runRootContext() {
        ++this.totalRuns;
        return this.runRootContext(new Handler(), true);
    }

    public Report getReport() {
        return new Report(this.totalRuns, this.totalMatches, this.totalMismatches, this.totalRematches, this.totalRemismatches, this.totalNanoTime, new ArrayList<RuleReport>(this.ruleReports.values()));
    }

    public static class RuleReport {
        private final Matcher matcher;
        private int matches;
        private int matchSubs;
        private int mismatches;
        private int mismatchSubs;
        private int rematches;
        private int rematchSubs;
        private int remismatches;
        private int remismatchSubs;
        private long nanoTime;

        public RuleReport(Matcher matcher) {
            this.matcher = matcher;
        }

        public Matcher getMatcher() {
            return this.matcher;
        }

        public int getInvocations() {
            return this.matches + this.mismatches;
        }

        public int getInvocationSubs() {
            return this.matchSubs + this.mismatchSubs;
        }

        public int getMatches() {
            return this.matches;
        }

        public int getMatchSubs() {
            return this.matchSubs;
        }

        public int getMismatches() {
            return this.mismatches;
        }

        public int getMismatchSubs() {
            return this.mismatchSubs;
        }

        public double getMatchShare() {
            return (double)this.matches / (double)this.getInvocations();
        }

        public double getMatchShare2() {
            return (double)this.matchSubs / (double)this.getInvocationSubs();
        }

        public int getReinvocations() {
            return this.rematches + this.remismatches;
        }

        public int getReinvocationSubs() {
            return this.rematchSubs + this.remismatchSubs;
        }

        public int getRematches() {
            return this.rematches;
        }

        public int getRematchSubs() {
            return this.rematchSubs;
        }

        public int getRemismatches() {
            return this.remismatches;
        }

        public int getRemismatchSubs() {
            return this.remismatchSubs;
        }

        public double getReinvocationShare() {
            return (double)this.getReinvocations() / (double)this.getInvocations();
        }

        public double getReinvocationShare2() {
            return (double)this.getReinvocationSubs() / (double)this.getInvocationSubs();
        }

        public long getNanoTime() {
            return this.nanoTime;
        }

        public void update(int matchesDelta, int matchSubsDelta, int mismatchesDelta, int mismatchSubsDelta, int rematchesDelta, int rematchSubsDelta, int remismatchesDelta, int remismatchSubsDelta, long nanoTimeDelta) {
            this.matches += matchesDelta;
            this.matchSubs += matchSubsDelta;
            this.mismatches += mismatchesDelta;
            this.mismatchSubs += mismatchSubsDelta;
            this.rematches += rematchesDelta;
            this.rematchSubs += rematchSubsDelta;
            this.remismatches += remismatchesDelta;
            this.remismatchSubs += remismatchSubsDelta;
            this.nanoTime += nanoTimeDelta;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Report {
        private static final DecimalFormat fmt = new DecimalFormat("0.###");
        public static final Predicate<RuleReport> allRules = new Predicate<RuleReport>(){

            @Override
            public boolean apply(RuleReport rep) {
                return true;
            }
        };
        public static final Predicate<RuleReport> namedRules = new Predicate<RuleReport>(){

            @Override
            public boolean apply(RuleReport rep) {
                return rep.getMatcher().hasCustomLabel();
            }
        };
        public final int totalRuns;
        public final int totalInvocations;
        public final int totalMatches;
        public final int totalMismatches;
        public final double matchShare;
        public final int reinvocations;
        public final int rematches;
        public final int remismatches;
        public final double reinvocationShare;
        public final long totalNanoTime;
        public final List<RuleReport> ruleReports;

        public Report(int totalRuns, int totalMatches, int totalMismatches, int rematches, int remismatches, long totalNanoTime, List<RuleReport> ruleReports) {
            this.totalRuns = totalRuns;
            this.totalInvocations = totalMatches + totalMismatches;
            this.totalMatches = totalMatches;
            this.totalMismatches = totalMismatches;
            this.matchShare = (double)totalMatches / (double)this.totalInvocations;
            this.reinvocations = rematches + remismatches;
            this.rematches = rematches;
            this.remismatches = remismatches;
            this.reinvocationShare = (double)this.reinvocations / (double)this.totalInvocations;
            this.totalNanoTime = totalNanoTime;
            this.ruleReports = ruleReports;
        }

        public String print() {
            StringBuilder sb = new StringBuilder();
            sb.append("Profiling Report\n");
            sb.append("----------------\n");
            sb.append(this.printBasics());
            sb.append("\n");
            sb.append("Top 20 named rules by invocations:\n");
            sb.append(this.sortByInvocations().printTopRules(20, namedRules));
            sb.append("\n");
            sb.append("Top 20 named rules by sub-invocations:\n");
            sb.append(this.sortBySubInvocations().printTopRules(20, namedRules));
            sb.append("\n");
            sb.append("Top 20 named rules by re-invocations:\n");
            sb.append(this.sortByReinvocations().printTopRules(20, namedRules));
            sb.append("\n");
            sb.append("Top 20 named rules by re-sub-invocations:\n");
            sb.append(this.sortByResubinvocations().printTopRules(20, namedRules));
            sb.append("\n");
            sb.append("Top 20 named rules by re-mismatches:\n");
            sb.append(this.sortByRemismatches().printTopRules(20, namedRules));
            sb.append("\n");
            sb.append("Top 20 named rules by re-sub-mismatches:\n");
            sb.append(this.sortByResubmismatches().printTopRules(20, namedRules));
            return sb.toString();
        }

        public String printBasics() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Runs                     : %,15d\n", this.totalRuns));
            sb.append(String.format("Active rules             : %,15d\n", this.ruleReports.size()));
            sb.append(String.format("Total net rule time      : %,15.3f s\n", (double)this.totalNanoTime / 1.0E9));
            sb.append(String.format("Total rule invocations   : %,15d\n", this.totalInvocations));
            sb.append(String.format("Total rule matches       : %,15d\n", this.totalMatches));
            sb.append(String.format("Total rule mismatches    : %,15d\n", this.totalMismatches));
            sb.append(String.format("Total match share        : %15.2f %%\n", 100.0 * this.matchShare));
            sb.append(String.format("Rule re-invocations      : %,15d\n", this.reinvocations));
            sb.append(String.format("Rule re-matches          : %,15d\n", this.rematches));
            sb.append(String.format("Rule re-mismatches       : %,15d\n", this.remismatches));
            sb.append(String.format("Rule re-invocation share : %15.2f %%\n", 100.0 * this.reinvocationShare));
            return sb.toString();
        }

        public String printTopRules(int count, Predicate<RuleReport> filter) {
            Preconditions.checkArgNotNull(filter, "filter");
            StringBuilder sb = new StringBuilder();
            sb.append("Rule                           | Net-Time  |   Invocations   |     Matches     |   Mismatches    |   Time/Invoc.   | Match % |    Re-Invocs    |   Re-Matches    |   Re-Mismatch   |     Re-Invoc %    \n");
            sb.append("-------------------------------|-----------|-----------------|-----------------|-----------------|-----------------|---------|-----------------|-----------------|-----------------|-------------------\n");
            for (int i = 0; i < Math.min(this.ruleReports.size(), count); ++i) {
                RuleReport rep = this.ruleReports.get(i);
                if (!filter.apply(rep)) {
                    ++count;
                    continue;
                }
                sb.append(String.format("%-30s | %6.0f ms | %6s / %6s | %6s / %6s | %6s / %6s | %,12.0f ns | %6.2f%% | %6s / %6s | %6s / %6s | %6s / %6s | %6.2f%% / %6.2f%%\n", StringUtils.left(rep.getMatcher().toString() + ": " + rep.getMatcher().getClass().getSimpleName().replace("Matcher", ""), 30), (double)rep.getNanoTime() / 1000000.0, Utils.humanize(rep.getInvocations()), Utils.humanize(rep.getInvocationSubs()), Utils.humanize(rep.getMatches()), Utils.humanize(rep.getMatchSubs()), Utils.humanize(rep.getMismatches()), Utils.humanize(rep.getMismatchSubs()), (double)rep.getNanoTime() / (double)rep.getInvocations(), rep.getMatchShare() * 100.0, Utils.humanize(rep.getReinvocations()), Utils.humanize(rep.getReinvocationSubs()), Utils.humanize(rep.getRematches()), Utils.humanize(rep.getRematchSubs()), Utils.humanize(rep.getRemismatches()), Utils.humanize(rep.getRemismatchSubs()), rep.getReinvocationShare() * 100.0, rep.getReinvocationShare2() * 100.0));
            }
            return sb.toString();
        }

        public Report sortByInvocations() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport a, RuleReport b) {
                    return Report.this.intCompare(a.getInvocations(), b.getInvocations());
                }
            });
            return this;
        }

        public Report sortBySubInvocations() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport a, RuleReport b) {
                    return Report.this.intCompare(a.getInvocationSubs(), b.getInvocationSubs());
                }
            });
            return this;
        }

        public Report sortByTime() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport a, RuleReport b) {
                    return Report.this.longCompare(a.getNanoTime(), b.getNanoTime());
                }
            });
            return this;
        }

        public Report sortByTimePerInvocation() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport a, RuleReport b) {
                    return Report.this.doubleCompare((double)a.getNanoTime() / (double)a.getInvocations(), (double)b.getNanoTime() / (double)b.getInvocations());
                }
            });
            return this;
        }

        public Report sortByMatches() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport a, RuleReport b) {
                    return Report.this.intCompare(a.getMatches(), b.getMatches());
                }
            });
            return this;
        }

        public Report sortByMismatches() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport a, RuleReport b) {
                    return Report.this.intCompare(a.getMismatches(), b.getMismatches());
                }
            });
            return this;
        }

        public Report sortByReinvocations() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport a, RuleReport b) {
                    return Report.this.intCompare(a.getReinvocations(), b.getReinvocations());
                }
            });
            return this;
        }

        public Report sortByResubinvocations() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport a, RuleReport b) {
                    return Report.this.doubleCompare(a.getReinvocationSubs(), b.getReinvocationSubs());
                }
            });
            return this;
        }

        public Report sortByRematches() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport a, RuleReport b) {
                    return Report.this.intCompare(a.getRematches(), b.getRematches());
                }
            });
            return this;
        }

        public Report sortByRemismatches() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport a, RuleReport b) {
                    return Report.this.intCompare(a.getRemismatches(), b.getRemismatches());
                }
            });
            return this;
        }

        public Report sortByResubmismatches() {
            Collections.sort(this.ruleReports, new Comparator<RuleReport>(){

                @Override
                public int compare(RuleReport a, RuleReport b) {
                    return Report.this.doubleCompare(a.getRemismatchSubs(), b.getRemismatchSubs());
                }
            });
            return this;
        }

        private int intCompare(int a, int b) {
            return a < b ? 1 : (a > b ? -1 : 0);
        }

        private int longCompare(long a, long b) {
            return a < b ? 1 : (a > b ? -1 : 0);
        }

        private int doubleCompare(double a, double b) {
            return a < b ? 1 : (a > b ? -1 : 0);
        }
    }

    private static class RuleStats {
        private int matches;
        private int mismatches;
        private int matchSubs;
        private int mismatchSubs;
        private int rematchSubs;
        private int remismatchSubs;
        private long nanoTime;
        private final Map<Integer, Integer> positionMatches = new HashMap<Integer, Integer>();

        private RuleStats() {
        }

        private void clear() {
            this.matches = 0;
            this.mismatches = 0;
            this.matchSubs = 0;
            this.mismatchSubs = 0;
            this.rematchSubs = 0;
            this.remismatchSubs = 0;
            this.nanoTime = 0L;
            this.positionMatches.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Handler
    implements MatchHandler {
        private long timeCorrection;
        private int totalMatches;

        @Override
        public boolean matchRoot(MatcherContext<?> rootContext) {
            rootContext.getMatcher().accept(new DoWithMatcherVisitor(new DoWithMatcherVisitor.Action(){

                public void process(Matcher matcher) {
                    RuleStats ruleStats = (RuleStats)matcher.getTag();
                    if (ruleStats == null) {
                        ruleStats = new RuleStats();
                        matcher.setTag(ruleStats);
                    } else {
                        ruleStats.clear();
                    }
                }
            }));
            this.totalMatches = 0;
            long timeStamp = System.nanoTime() - this.timeCorrection;
            boolean matched = rootContext.runMatcher();
            ProfilingParseRunner.this.totalNanoTime += System.nanoTime() - this.timeCorrection - timeStamp;
            ProfilingParseRunner.this.rootMatcher.accept(new DoWithMatcherVisitor(ProfilingParseRunner.this.updateStatsAction));
            return matched;
        }

        @Override
        public boolean match(MatcherContext<?> context) {
            long timeStamp = System.nanoTime();
            Matcher matcher = context.getMatcher();
            RuleStats ruleStats = (RuleStats)matcher.getTag();
            int pos = context.getCurrentIndex();
            int subMatches = -(++this.totalMatches);
            int matchSubs = ruleStats.matchSubs;
            int rematchSubs = ruleStats.rematchSubs;
            int mismatchSubs = ruleStats.mismatchSubs;
            int remismatchSubs = ruleStats.remismatchSubs;
            long time = System.nanoTime();
            this.timeCorrection += time - timeStamp;
            timeStamp = time - this.timeCorrection;
            boolean matched = matcher.match(context);
            time = System.nanoTime();
            ruleStats.nanoTime += time - this.timeCorrection - timeStamp;
            timeStamp = time;
            subMatches += this.totalMatches;
            Integer posMatches = (Integer)ruleStats.positionMatches.get(pos);
            if (matched) {
                ruleStats.matches++;
                ruleStats.matchSubs = matchSubs + subMatches;
                if (posMatches == null) {
                    posMatches = 1;
                } else if (posMatches > 0) {
                    Integer n = posMatches;
                    Integer n2 = posMatches = Integer.valueOf(posMatches + 1);
                    ruleStats.rematchSubs = rematchSubs + subMatches;
                } else if (posMatches < 0) {
                    posMatches = 0;
                }
            } else {
                ruleStats.mismatches++;
                ruleStats.mismatchSubs = mismatchSubs + subMatches;
                if (posMatches == null) {
                    posMatches = -1;
                } else if (posMatches < 0) {
                    Integer n = posMatches;
                    Integer n3 = posMatches = Integer.valueOf(posMatches - 1);
                    ruleStats.remismatchSubs = remismatchSubs + subMatches;
                } else if (posMatches > 0) {
                    posMatches = 0;
                }
            }
            ruleStats.positionMatches.put(pos, posMatches);
            this.timeCorrection += System.nanoTime() - timeStamp;
            return matched;
        }
    }
}

