/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Preconditions;
import org.parboiled.errors.GrammarException;
import org.parboiled.matchers.FirstOfMatcher;

public class FirstOfStringsMatcher
extends FirstOfMatcher {
    private final Record root;
    public final char[][] strings;

    public FirstOfStringsMatcher(Rule[] subRules, char[][] strings) {
        super(Preconditions.checkArgNotNull(subRules, "subRules"));
        FirstOfStringsMatcher.verify(strings);
        this.strings = strings;
        this.root = FirstOfStringsMatcher.createRecord(0, strings);
    }

    public boolean match(MatcherContext context) {
        Preconditions.checkArgNotNull(context, "context");
        if (!context.fastStringMatching()) {
            return super.match(context);
        }
        Record rec = this.root;
        int ix = context.getCurrentIndex();
        InputBuffer buffer = context.getInputBuffer();
        char c = context.getCurrentChar();
        int endIx = -1;
        block0: while (true) {
            char[] chars = rec.chars;
            for (int i = 0; i < chars.length; ++i) {
                if (c != chars[i]) continue;
                ++ix;
                rec = rec.subs[i];
                if (rec == null) {
                    endIx = ix;
                    break block0;
                }
                if (rec.complete) {
                    endIx = ix;
                }
                c = buffer.charAt(ix);
                continue block0;
            }
            break;
        }
        if (endIx == -1) {
            return false;
        }
        context.advanceIndex(endIx - context.getCurrentIndex());
        context.createNode();
        return true;
    }

    static Record createRecord(int pos, char[][] strings) {
        TreeMap<Character, HashSet<char[]>> map = new TreeMap<Character, HashSet<char[]>>();
        boolean complete = false;
        for (char[] s : strings) {
            if (s.length == pos) {
                complete = true;
            }
            if (s.length <= pos) continue;
            char c = s[pos];
            HashSet<char[]> charStrings = (HashSet<char[]>)map.get(Character.valueOf(c));
            if (charStrings == null) {
                charStrings = new HashSet<char[]>();
                map.put(Character.valueOf(c), charStrings);
            }
            charStrings.add(s);
        }
        if (map.isEmpty()) {
            return null;
        }
        char[] chars = new char[map.size()];
        Record[] subs = new Record[map.size()];
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            chars[i] = ((Character)entry.getKey()).charValue();
            subs[i++] = FirstOfStringsMatcher.createRecord(pos + 1, (char[][])((Set)entry.getValue()).toArray((T[])new char[((Set)entry.getValue()).size()][]));
        }
        return new Record(chars, subs, complete);
    }

    private static void verify(char[][] strings) {
        int length = strings.length;
        for (int i = 0; i < length; ++i) {
            char[] a = strings[i];
            block1: for (int j = i + 1; j < length; ++j) {
                char[] b = strings[j];
                if (b.length < a.length) continue;
                for (int k = 0; k < a.length; ++k) {
                    if (a[k] != b[k]) continue block1;
                }
                String sa = '\"' + String.valueOf(a) + '\"';
                String sb = '\"' + String.valueOf(b) + '\"';
                String msg = a.length == b.length ? sa + " is specified twice in a FirstOf(String...)" : sa + " is a prefix of " + sb + " in a FirstOf(String...) and comes before " + sb + ", which prevents " + sb + " from ever matching! You should reverse the order of the two alternatives.";
                throw new GrammarException(msg);
            }
        }
    }

    static class Record {
        final char[] chars;
        final Record[] subs;
        final boolean complete;

        private Record(char[] chars, Record[] subs, boolean complete) {
            this.chars = chars;
            this.subs = subs;
            this.complete = complete;
        }
    }
}

