/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.errors;

import java.util.List;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Formatter;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.errors.DefaultInvalidInputErrorFormatter;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.errors.ParseError;
import org.parboiled.matchers.Matcher;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.ParsingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ErrorUtils {
    private ErrorUtils() {
    }

    static Matcher findProperLabelMatcher(MatcherPath path, int errorIndex) {
        Matcher found;
        Preconditions.checkArgNotNull(path, "path");
        Matcher matcher = found = path.parent != null ? ErrorUtils.findProperLabelMatcher(path.parent, errorIndex) : null;
        if (found != null) {
            return found;
        }
        if (path.element.startIndex == errorIndex && path.element.matcher.hasCustomLabel()) {
            return path.element.matcher;
        }
        return null;
    }

    public static String printParseErrors(ParsingResult<?> parsingResult) {
        Preconditions.checkArgNotNull(parsingResult, "parsingResult");
        return ErrorUtils.printParseErrors(parsingResult.parseErrors, parsingResult.inputBuffer);
    }

    public static String printParseErrors(List<ParseError> errors, InputBuffer inputBuffer) {
        Preconditions.checkArgNotNull(errors, "errors");
        Preconditions.checkArgNotNull(inputBuffer, "inputBuffer");
        StringBuilder sb = new StringBuilder();
        for (ParseError error : errors) {
            if (sb.length() > 0) {
                sb.append("---\n");
            }
            sb.append(ErrorUtils.printParseError(error, inputBuffer));
        }
        return sb.toString();
    }

    public static String printParseError(ParseError error, InputBuffer inputBuffer) {
        Preconditions.checkArgNotNull(error, "error");
        Preconditions.checkArgNotNull(inputBuffer, "inputBuffer");
        return ErrorUtils.printParseError(error, inputBuffer, new DefaultInvalidInputErrorFormatter());
    }

    public static String printParseError(ParseError error, InputBuffer inputBuffer, Formatter<InvalidInputError> formatter) {
        Preconditions.checkArgNotNull(error, "error");
        Preconditions.checkArgNotNull(inputBuffer, "inputBuffer");
        Preconditions.checkArgNotNull(formatter, "formatter");
        String message = error.getErrorMessage() != null ? error.getErrorMessage() : (error instanceof InvalidInputError ? formatter.format((InvalidInputError)error) : error.getClass().getSimpleName());
        return ErrorUtils.printErrorMessage("%s (line %s, pos %s):", message, error.getStartIndex(), error.getEndIndex(), inputBuffer);
    }

    public static String printErrorMessage(String format, String errorMessage, int errorIndex, InputBuffer inputBuffer) {
        Preconditions.checkArgNotNull(inputBuffer, "inputBuffer");
        return ErrorUtils.printErrorMessage(format, errorMessage, errorIndex, errorIndex + 1, inputBuffer);
    }

    public static String printErrorMessage(String format, String errorMessage, int startIndex, int endIndex, InputBuffer inputBuffer) {
        int i;
        Preconditions.checkArgNotNull(inputBuffer, "inputBuffer");
        Preconditions.checkArgument(startIndex < endIndex);
        InputBuffer.Position pos = inputBuffer.getPosition(startIndex);
        StringBuilder sb = new StringBuilder(String.format(format, errorMessage, pos.line, pos.column));
        sb.append('\n');
        String line = inputBuffer.extractLine(pos.line);
        sb.append(line);
        sb.append('\n');
        int charCount = Math.min(endIndex - startIndex, StringUtils.length(line) - pos.column + 2);
        for (i = 0; i < pos.column - 1; ++i) {
            sb.append(' ');
        }
        for (i = 0; i < charCount; ++i) {
            sb.append('^');
        }
        sb.append("\n");
        return sb.toString();
    }
}

