/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.errors;

import java.util.ArrayList;
import java.util.List;
import org.parboiled.common.Formatter;
import org.parboiled.common.StringUtils;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.matchers.AnyOfMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.support.MatcherPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInvalidInputErrorFormatter
implements Formatter<InvalidInputError> {
    @Override
    public String format(InvalidInputError error) {
        if (error == null) {
            return "";
        }
        String errorMessage = String.format("Invalid input '%s%s'", StringUtils.escape(String.valueOf(error.getInputBuffer().charAt(error.getStartIndex()))), error.getEndIndex() - error.getStartIndex() > 1 ? "..." : "");
        String expectedString = this.getExpectedString(error);
        return StringUtils.isEmpty(expectedString) ? errorMessage : errorMessage + ", expected " + expectedString;
    }

    public String getExpectedString(InvalidInputError error) {
        int pathStartIndex = error.getStartIndex() - error.getIndexDelta();
        ArrayList<String> labelList = new ArrayList<String>();
        for (MatcherPath path : error.getFailedMatchers()) {
            String[] labels;
            Matcher labelMatcher = ErrorUtils.findProperLabelMatcher(path, pathStartIndex);
            if (labelMatcher == null) continue;
            for (String label : labels = this.getLabels(labelMatcher)) {
                if (label == null || labelList.contains(label)) continue;
                labelList.add(label);
            }
        }
        return this.join(labelList);
    }

    public String[] getLabels(Matcher matcher) {
        if (matcher instanceof AnyOfMatcher && ((AnyOfMatcher)matcher).characters.toString().equals(matcher.getLabel())) {
            AnyOfMatcher cMatcher = (AnyOfMatcher)matcher;
            if (!cMatcher.characters.isSubtractive()) {
                String[] labels = new String[cMatcher.characters.getChars().length];
                for (int i = 0; i < labels.length; ++i) {
                    labels[i] = '\'' + String.valueOf(cMatcher.characters.getChars()[i]) + '\'';
                }
                return labels;
            }
        }
        return new String[]{matcher.getLabel()};
    }

    public String join(List<String> labelList) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < labelList.size(); ++i) {
            if (i > 0) {
                sb.append(i < labelList.size() - 1 ? ", " : " or ");
            }
            sb.append(labelList.get(i));
        }
        return StringUtils.escape(sb.toString());
    }
}

