/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.errors;

import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Preconditions;
import org.parboiled.errors.ParseError;

public class BasicParseError
implements ParseError {
    private final InputBuffer inputBuffer;
    private final int startIndex;
    private int endIndex;
    private final String errorMessage;
    private int indexDelta;

    public BasicParseError(InputBuffer inputBuffer, int errorIndex, String errorMessage) {
        this.inputBuffer = Preconditions.checkArgNotNull(inputBuffer, "inputBuffer");
        this.startIndex = errorIndex;
        this.endIndex = errorIndex + 1;
        this.errorMessage = errorMessage;
    }

    public InputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    public int getStartIndex() {
        return this.startIndex + this.indexDelta;
    }

    public int getEndIndex() {
        return this.endIndex + this.indexDelta;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex - this.indexDelta;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getIndexDelta() {
        return this.indexDelta;
    }

    public void shiftIndexDeltaBy(int delta) {
        this.indexDelta += delta;
    }
}

