/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.common;

import java.util.AbstractList;
import java.util.List;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableList<T>
extends AbstractList<T> {
    public static final ImmutableList<?> EMPTY_LIST = new ImmutableList<Object>(new Object[0]);
    private final T[] array;

    private ImmutableList(T[] array) {
        this.array = array;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public T get(int index) {
        return this.array[index];
    }

    public static <T> ImmutableList<T> copyOf(List<T> other) {
        Preconditions.checkArgNotNull(other, "other");
        return (ImmutableList)(other instanceof ImmutableList ? other : ImmutableList.create(other.toArray()));
    }

    public static <T> ImmutableList<T> of() {
        return EMPTY_LIST;
    }

    public static <T> ImmutableList<T> of(T a) {
        return ImmutableList.create(a);
    }

    public static <T> ImmutableList<T> of(T a, T b) {
        return ImmutableList.create(a, b);
    }

    public static <T> ImmutableList<T> of(T a, T b, T c) {
        return ImmutableList.create(a, b, c);
    }

    public static <T> ImmutableList<T> of(T ... elements) {
        return ImmutableList.create((Object[])elements.clone());
    }

    public static <T> ImmutableList<T> of(T first, T[] more) {
        return ImmutableList.create(Utils.arrayOf(first, (Object[])more.clone()));
    }

    public static <T> ImmutableList<T> of(T[] first, T last) {
        Preconditions.checkArgNotNull(first, "first");
        return ImmutableList.create(Utils.arrayOf((Object[])first.clone(), last));
    }

    public static <T> ImmutableList<T> of(T first, ImmutableList<T> more) {
        Preconditions.checkArgNotNull(more, "more");
        return ImmutableList.create(Utils.arrayOf(first, more.array));
    }

    public static <T> ImmutableList<T> of(ImmutableList<T> first, T last) {
        Preconditions.checkArgNotNull(first, "first");
        return ImmutableList.create(Utils.arrayOf(first.array, last));
    }

    private static <T> ImmutableList<T> create(T ... elements) {
        return new ImmutableList<T>(elements);
    }
}

