/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.buffers;

import java.util.Arrays;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Preconditions;

public class MutableInputBuffer
implements InputBuffer {
    private final InputBuffer buffer;
    private int[] inserts = new int[0];
    private char[] chars = new char[0];

    public MutableInputBuffer(InputBuffer buffer) {
        this.buffer = buffer;
    }

    public char charAt(int index) {
        int j = Arrays.binarySearch(this.inserts, index);
        if (j >= 0) {
            return this.chars[j];
        }
        return this.buffer.charAt(index + (j + 1));
    }

    public boolean test(int index, char[] characters) {
        throw new UnsupportedOperationException();
    }

    public InputBuffer.Position getPosition(int index) {
        return this.buffer.getPosition(this.fix(index));
    }

    public String extractLine(int lineNumber) {
        return this.buffer.extractLine(lineNumber);
    }

    public String extract(int start, int end) {
        return this.buffer.extract(this.fix(start), this.fix(end));
    }

    public int getLineCount() {
        return this.buffer.getLineCount();
    }

    private int fix(int index) {
        int j = Arrays.binarySearch(this.inserts, index);
        if (j < 0) {
            j = -(j + 1);
        }
        return index - j;
    }

    public void insertChar(int index, char c) {
        int j = Arrays.binarySearch(this.inserts, index);
        if (j < 0) {
            j = -(j + 1);
        }
        char[] newChars = new char[this.chars.length + 1];
        System.arraycopy(this.chars, 0, newChars, 0, j);
        newChars[j] = c;
        System.arraycopy(this.chars, j, newChars, j + 1, this.chars.length - j);
        this.chars = newChars;
        int[] newInserts = new int[this.inserts.length + 1];
        System.arraycopy(this.inserts, 0, newInserts, 0, j);
        newInserts[j] = index;
        for (int i = j; i < this.inserts.length; ++i) {
            newInserts[i + 1] = this.inserts[i] + 1;
        }
        this.inserts = newInserts;
    }

    public char undoCharInsertion(int index) {
        int j = Arrays.binarySearch(this.inserts, index);
        Preconditions.checkArgument(j >= 0, "Cannot undo a non-existing insertion");
        char removedChar = this.chars[j];
        char[] newChars = new char[this.chars.length - 1];
        System.arraycopy(this.chars, 0, newChars, 0, j);
        System.arraycopy(this.chars, j + 1, newChars, j, newChars.length - j);
        this.chars = newChars;
        int[] newInserts = new int[this.inserts.length - 1];
        System.arraycopy(this.inserts, 0, newInserts, 0, j);
        for (int i = j + 1; i < this.inserts.length; ++i) {
            newInserts[i - 1] = this.inserts[i] - 1;
        }
        this.inserts = newInserts;
        return removedChar;
    }
}

