/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.buffers;

import org.parboiled.buffers.DefaultInputBuffer;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.IntArrayStack;
import org.parboiled.common.Preconditions;

public class IndentDedentInputBuffer
extends DefaultInputBuffer {
    protected final int length2;
    protected final char[] buffer2;
    protected int[] newlines2;
    protected final int tabStop;

    public IndentDedentInputBuffer(char[] input, int tabStop) {
        super(input);
        Preconditions.checkArgument(tabStop > 0, "tabStop must be > 0");
        this.tabStop = tabStop;
        this.buffer2 = this.buildBuffer2();
        this.length2 = this.buffer2.length;
    }

    public char charAt(int index) {
        return 0 <= index && index < this.length2 ? this.buffer2[index] : (char)'\uffff';
    }

    public boolean test(int index, char[] characters) {
        int len = characters.length;
        if (index < 0 || index > this.length2 - len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.buffer2[index + i] == characters[i]) continue;
            return false;
        }
        return true;
    }

    public String extract(int start, int end) {
        return super.extract(this.translate(start), this.translate(end));
    }

    public InputBuffer.Position getPosition(int index) {
        return super.getPosition(this.translate(index));
    }

    protected int translate(int ix2) {
        int line = IndentDedentInputBuffer.getLine0(this.newlines2, ix2 = Math.min(Math.max(ix2, 0), this.length2));
        int original = line >= this.newlines.length ? this.buffer.length : this.newlines[line];
        int adapted = this.newlines2[Math.min(line, this.newlines2.length - 1)];
        return ix2 + original - adapted;
    }

    protected char[] buildBuffer2() {
        StringBuilder sb = new StringBuilder();
        IntArrayStack previousLevels = new IntArrayStack();
        IntArrayStack newlines = new IntArrayStack();
        IntArrayStack newlines2 = new IntArrayStack();
        int length = this.buffer.length;
        int currentLevel = 0;
        int cursor = 0;
        previousLevels.push(0);
        block8: while (cursor < length) {
            switch (this.buffer[cursor]) {
                case ' ': {
                    ++cursor;
                    ++currentLevel;
                    continue block8;
                }
                case '\t': {
                    ++cursor;
                    currentLevel = (currentLevel / this.tabStop + 1) * this.tabStop;
                    continue block8;
                }
            }
        }
        int indexDelta = currentLevel;
        while (cursor < length) {
            char c = this.buffer[cursor++];
            sb.append(c);
            if (c != '\n') continue;
            newlines.push(cursor - 1);
            newlines2.push(cursor - indexDelta - 1);
            int indent = 0;
            block10: while (cursor < length) {
                switch (this.buffer[cursor]) {
                    case ' ': {
                        ++cursor;
                        ++indexDelta;
                        ++indent;
                        continue block10;
                    }
                    case '\t': {
                        ++cursor;
                        ++indexDelta;
                        indent = (indent / this.tabStop + 1) * this.tabStop;
                        continue block10;
                    }
                }
            }
            if (indent > currentLevel) {
                previousLevels.push(currentLevel);
                currentLevel = indent;
                sb.append('\ufdd0');
                --indexDelta;
                continue;
            }
            while (indent < currentLevel && indent <= previousLevels.peek()) {
                currentLevel = previousLevels.pop();
                sb.append('\ufdd1');
                --indexDelta;
            }
        }
        if (previousLevels.size() > 1) {
            sb.append('\n');
            newlines.push(cursor);
            newlines2.push(cursor - indexDelta);
            while (previousLevels.size() > 1) {
                previousLevels.pop();
                sb.append('\ufdd1');
            }
        }
        this.newlines = new int[newlines.size()];
        newlines.getElements(this.newlines, 0);
        this.newlines2 = new int[newlines2.size()];
        newlines2.getElements(this.newlines2, 0);
        char[] buffer = new char[sb.length()];
        sb.getChars(0, sb.length(), buffer, 0);
        return buffer;
    }
}

