/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.buffers;

import java.util.Arrays;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Preconditions;

public class DefaultInputBuffer
implements InputBuffer {
    protected final int length;
    protected final char[] buffer;
    protected int[] newlines;

    public DefaultInputBuffer(char[] buffer) {
        Preconditions.checkArgNotNull(buffer, "buffer");
        this.buffer = buffer;
        this.length = buffer.length;
    }

    public char charAt(int index) {
        return 0 <= index && index < this.length ? this.buffer[index] : (char)'\uffff';
    }

    public boolean test(int index, char[] characters) {
        int len = characters.length;
        if (index < 0 || index > this.length - len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.buffer[index + i] == characters[i]) continue;
            return false;
        }
        return true;
    }

    public String extract(int start, int end) {
        return this.extractInternal(start, end);
    }

    public InputBuffer.Position getPosition(int index) {
        this.buildNewlines();
        int line = DefaultInputBuffer.getLine0(this.newlines, index);
        int column = index - (line > 0 ? this.newlines[line - 1] : -1);
        return new InputBuffer.Position(line + 1, column);
    }

    protected static int getLine0(int[] newlines, int index) {
        int j = Arrays.binarySearch(newlines, index);
        return j >= 0 ? j : -(j + 1);
    }

    public String extractLine(int lineNumber) {
        int end;
        this.buildNewlines();
        Preconditions.checkArgument(0 < lineNumber && lineNumber <= this.newlines.length + 1);
        int start = lineNumber > 1 ? this.newlines[lineNumber - 2] + 1 : 0;
        int n = end = lineNumber <= this.newlines.length ? this.newlines[lineNumber - 1] : this.length;
        if (this.charAt(end - 1) == '\r') {
            --end;
        }
        return this.extractInternal(start, end);
    }

    private String extractInternal(int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end >= this.length) {
            end = this.length;
        }
        if (end <= start) {
            return "";
        }
        return new String(this.buffer, start, end - start);
    }

    public int getLineCount() {
        this.buildNewlines();
        return this.newlines.length + 1;
    }

    protected void buildNewlines() {
        if (this.newlines == null) {
            int i;
            int count = 0;
            for (i = 0; i < this.length; ++i) {
                if (this.buffer[i] != '\n') continue;
                ++count;
            }
            this.newlines = new int[count];
            count = 0;
            for (i = 0; i < this.length; ++i) {
                if (this.buffer[i] != '\n') continue;
                this.newlines[count++] = i;
            }
        }
    }
}

