/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.jpackage;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.panteleyev.jpackage.CommandLineParameter;

class Parameters {
    private final List<String> params = new ArrayList<String>(60);
    private final Logger logger;
    private final Directory projectDirectory;

    public Parameters(Logger logger, Directory projectDirectory) {
        this.logger = logger;
        this.projectDirectory = projectDirectory;
    }

    public List<String> getParams() {
        return this.params;
    }

    public void add(String value) {
        this.logger.info("  {}", (Object)value);
        this.params.add(value);
    }

    public void addString(CommandLineParameter parameter, String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        this.logger.info("  {} {}", (Object)parameter.getName(), (Object)value);
        this.params.add(parameter.getName());
        this.params.add(value);
    }

    public void addString(CommandLineParameter parameter, Property<String> prop) {
        String value = (String)prop.getOrElse((Object)"");
        if (value.isEmpty()) {
            return;
        }
        this.logger.info("  {} {}", (Object)parameter.getName(), (Object)value);
        this.params.add(parameter.getName());
        this.params.add(value);
    }

    public void addBoolean(CommandLineParameter parameter, Property<Boolean> prop) {
        if (!((Boolean)prop.getOrElse((Object)false)).booleanValue()) {
            return;
        }
        this.logger.info("  {}", (Object)parameter.getName());
        this.params.add(parameter.getName());
    }

    public void addFile(CommandLineParameter parameter, Property<String> prop, boolean mustExist) {
        if (!prop.isPresent()) {
            return;
        }
        String value = (String)prop.get();
        if (value.isEmpty()) {
            return;
        }
        File file = this.projectDirectory.file(value).getAsFile();
        if (mustExist && !file.exists()) {
            throw new GradleException("File or directory " + file.getAbsolutePath() + " does not exist");
        }
        this.logger.info("  {} {}", (Object)parameter.getName(), (Object)file.getAbsolutePath());
        this.params.add(parameter.getName());
        this.params.add(file.getAbsolutePath());
    }

    public void addFile(CommandLineParameter parameter, RegularFileProperty prop, boolean mustExist) {
        if (!prop.isPresent()) {
            return;
        }
        File file = ((RegularFile)prop.get()).getAsFile();
        if (mustExist && !file.exists()) {
            throw new GradleException("File or directory " + file.getAbsolutePath() + " does not exist");
        }
        this.logger.info("  {} {}", (Object)parameter.getName(), (Object)file.getAbsolutePath());
        this.params.add(parameter.getName());
        this.params.add(file.getAbsolutePath());
    }

    public void addFile(CommandLineParameter parameter, DirectoryProperty prop, boolean mustExist) {
        if (!prop.isPresent()) {
            return;
        }
        File file = ((Directory)prop.get()).getAsFile();
        if (mustExist && !file.exists()) {
            throw new GradleException("File or directory " + file.getAbsolutePath() + " does not exist");
        }
        this.logger.info("  {} {}", (Object)parameter.getName(), (Object)file.getAbsolutePath());
        this.params.add(parameter.getName());
        this.params.add(file.getAbsolutePath());
    }

    public void addFile(CommandLineParameter parameter, String value, boolean mustExist) {
        if (value == null || value.isEmpty()) {
            return;
        }
        File file = this.projectDirectory.file(value).getAsFile();
        if (mustExist && !file.exists()) {
            throw new GradleException("File or directory " + file.getAbsolutePath() + " does not exist");
        }
        this.logger.info("  {} {}", (Object)parameter.getName(), (Object)file.getAbsolutePath());
        this.params.add(parameter.getName());
        this.params.add(file.getAbsolutePath());
    }

    public void addFile(CommandLineParameter parameter, File file, boolean mustExist) {
        if (mustExist && !file.exists()) {
            throw new GradleException("File or directory " + file.getAbsolutePath() + " does not exist");
        }
        this.logger.info("  {} {}", (Object)parameter.getName(), (Object)file.getAbsolutePath());
        this.params.add(parameter.getName());
        this.params.add(file.getAbsolutePath());
    }
}

