/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.jpackage;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.panteleyev.jpackage.CommandLineParameter;
import org.panteleyev.jpackage.DirectoryUtil;
import org.panteleyev.jpackage.ImageType;
import org.panteleyev.jpackage.Launcher;
import org.panteleyev.jpackage.OsUtil;
import org.panteleyev.jpackage.Parameters;
import org.panteleyev.jpackage.StringUtil;

public abstract class JPackageTask
extends DefaultTask {
    static final String EXECUTABLE = "jpackage";
    private final String projectVersion = this.getProject().getVersion().toString();
    private final boolean dryRun = Boolean.getBoolean("jpackage.dryRun");

    public JPackageTask() {
        try {
            JavaToolchainSpec toolchain = ((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getToolchain();
            Provider defaultLauncher = this.getJavaToolchainService().launcherFor(toolchain);
            this.getJavaLauncher().convention(defaultLauncher);
        }
        catch (Exception ex) {
            this.getLogger().trace("Failed to configure JavaLauncher");
        }
    }

    @Inject
    public abstract JavaToolchainService getJavaToolchainService();

    @Inject
    public abstract ProjectLayout getProjectLayout();

    @Nested
    @Optional
    public abstract Property<JavaLauncher> getJavaLauncher();

    @Input
    @Optional
    public abstract Property<String> getAboutUrl();

    @InputFiles
    @Optional
    public abstract ConfigurableFileCollection getAppContent();

    @Input
    @Optional
    public abstract Property<String> getAppDescription();

    @Input
    @Optional
    public abstract Property<String> getAppImage();

    @Input
    @Optional
    public abstract Property<String> getAppName();

    @Input
    @Optional
    public abstract Property<String> getAppVersion();

    @InputFiles
    @Optional
    public abstract ConfigurableFileCollection getFileAssociations();

    @InputFile
    @Optional
    public abstract RegularFileProperty getIcon();

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getRuntimeImage();

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getInput();

    @Input
    @Optional
    public abstract Property<String> getInstallDir();

    @OutputDirectory
    public abstract DirectoryProperty getDestination();

    @Input
    @Optional
    public abstract Property<String> getModule();

    @Input
    @Optional
    public abstract Property<String> getMainClass();

    @Input
    @Optional
    public abstract Property<String> getMainJar();

    @Input
    @Optional
    public abstract Property<String> getCopyright();

    @InputFiles
    @Optional
    public abstract ConfigurableFileCollection getModulePaths();

    @InputFile
    @Optional
    public abstract RegularFileProperty getLicenseFile();

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getResourceDir();

    @InputFile
    @Optional
    public abstract DirectoryProperty getTemp();

    @Input
    @Optional
    public abstract ListProperty<String> getJavaOptions();

    @Input
    @Optional
    public abstract ListProperty<String> getArguments();

    @Input
    @Optional
    public abstract ListProperty<Launcher> getLaunchers();

    @Input
    @Optional
    public abstract ListProperty<String> getAddModules();

    @Input
    @Optional
    @Deprecated
    public abstract Property<Boolean> getBindServices();

    @Input
    @Optional
    public abstract ListProperty<String> getJLinkOptions();

    @Input
    @Optional
    public abstract Property<Boolean> getLauncherAsService();

    @Input
    @Optional
    public abstract Property<ImageType> getType();

    @Input
    @Optional
    public abstract Property<String> getVendor();

    @Input
    @Optional
    public abstract Property<Boolean> getVerbose();

    @Input
    @Optional
    public abstract Property<Boolean> getWinMenu();

    @Input
    @Optional
    public abstract Property<Boolean> getWinDirChooser();

    @Input
    @Optional
    public abstract Property<String> getWinUpgradeUuid();

    @Input
    @Optional
    public abstract Property<String> getWinMenuGroup();

    @Input
    @Optional
    public abstract Property<Boolean> getWinShortcut();

    @Input
    @Optional
    public abstract Property<Boolean> getWinPerUserInstall();

    @Input
    @Optional
    public abstract Property<Boolean> getWinConsole();

    @Input
    @Optional
    public abstract Property<String> getWinHelpUrl();

    @Input
    @Optional
    public abstract Property<Boolean> getWinShortcutPrompt();

    @Input
    @Optional
    public abstract Property<String> getWinUpdateUrl();

    @Input
    @Optional
    public abstract Property<String> getMacPackageIdentifier();

    @Input
    @Optional
    public abstract Property<String> getMacPackageName();

    @Input
    @Optional
    public abstract Property<String> getMacPackageSigningPrefix();

    @Input
    @Optional
    public abstract Property<String> getMacBundleSigningPrefix();

    @Input
    @Optional
    public abstract Property<Boolean> getMacSign();

    @Input
    @Optional
    public abstract Property<String> getMacSigningKeychain();

    @Input
    @Optional
    public abstract Property<String> getMacSigningKeyUserName();

    @Input
    @Optional
    public abstract Property<Boolean> getMacAppStore();

    @Input
    @Optional
    public abstract Property<String> getMacAppCategory();

    @InputFile
    @Optional
    public abstract RegularFileProperty getMacEntitlements();

    @InputFiles
    @Optional
    public abstract ConfigurableFileCollection getMacDmgContent();

    @Input
    @Optional
    public abstract Property<String> getLinuxPackageName();

    @Input
    @Optional
    public abstract Property<String> getLinuxDebMaintainer();

    @Input
    @Optional
    public abstract Property<String> getLinuxMenuGroup();

    @Input
    @Optional
    public abstract Property<String> getLinuxRpmLicenseType();

    @Input
    @Optional
    public abstract Property<String> getLinuxAppRelease();

    @Input
    @Optional
    public abstract Property<String> getLinuxAppCategory();

    @Input
    @Optional
    public abstract Property<Boolean> getLinuxShortcut();

    @Input
    @Optional
    public abstract Property<Boolean> getLinuxPackageDeps();

    @Input
    @Optional
    public abstract ListProperty<String> getAdditionalParameters();

    @Input
    @Optional
    public abstract MapProperty<String, String> getJpackageEnvironment();

    @TaskAction
    public void action() {
        if (this.dryRun) {
            this.getLogger().lifecycle("Executing jpackage plugin in dry run mode");
        }
        String jpackage = this.getJPackageFromToolchain().orElseGet(() -> this.getJPackageFromJavaHome().orElseThrow(() -> new GradleException("Could not detect jpackage")));
        this.execute(jpackage);
    }

    private java.util.Optional<String> buildExecutablePath(String home) {
        String executable = home + File.separator + "bin" + File.separator + EXECUTABLE + (OsUtil.isWindows() ? ".exe" : "");
        if (new File(executable).exists()) {
            return java.util.Optional.of(executable);
        }
        this.getLogger().warn("File {} does not exist", (Object)executable);
        return java.util.Optional.empty();
    }

    private java.util.Optional<String> getJPackageFromToolchain() {
        this.getLogger().info("Looking for {} in toolchain", (Object)EXECUTABLE);
        try {
            JavaLauncher launcherValue = (JavaLauncher)this.getJavaLauncher().getOrNull();
            if (launcherValue == null) {
                throw new RuntimeException();
            }
            String home = launcherValue.getMetadata().getInstallationPath().getAsFile().getAbsolutePath();
            this.getLogger().info("toolchain: {}", (Object)home);
            return this.buildExecutablePath(home);
        }
        catch (Exception ex) {
            this.getLogger().info("Toolchain is not configured");
            return java.util.Optional.empty();
        }
    }

    private java.util.Optional<String> getJPackageFromJavaHome() {
        this.getLogger().info("Getting {} from java.home", (Object)EXECUTABLE);
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            this.getLogger().error("java.home is not set");
            return java.util.Optional.empty();
        }
        return this.buildExecutablePath(javaHome);
    }

    private void buildParameters(Parameters parameters) {
        List jLinkOptions;
        Iterator addModules;
        parameters.addString(CommandLineParameter.ABOUT_URL, this.getAboutUrl());
        if (this.getLaunchers().isPresent()) {
            for (Launcher launcher : (List)this.getLaunchers().get()) {
                File launcherFile = launcher.getFile();
                if (!launcherFile.exists()) {
                    throw new GradleException("Launcher file " + launcherFile.getAbsolutePath() + " does not exist");
                }
                parameters.addString(CommandLineParameter.ADD_LAUNCHER, launcher.getName() + "=" + launcherFile.getAbsolutePath());
            }
        }
        if (this.getAddModules().isPresent() && !(addModules = (List)this.getAddModules().get()).isEmpty()) {
            parameters.addString(CommandLineParameter.ADD_MODULES, String.join((CharSequence)",", (Iterable<? extends CharSequence>)((Object)addModules)));
        }
        this.getAppContent().forEach(file -> parameters.addFile(CommandLineParameter.APP_CONTENT, (File)file, true));
        this.getFileAssociations().forEach(file -> parameters.addFile(CommandLineParameter.FILE_ASSOCIATIONS, (File)file, true));
        parameters.addFile(CommandLineParameter.APP_IMAGE, this.getAppImage(), true);
        parameters.addString(CommandLineParameter.APP_VERSION, (String)this.getAppVersion().getOrElse((Object)this.projectVersion));
        if (this.getArguments().isPresent()) {
            for (Object arg : (List)this.getArguments().get()) {
                parameters.addString(CommandLineParameter.ARGUMENTS, StringUtil.escape(arg.toString()));
            }
        }
        parameters.addBoolean(CommandLineParameter.BIND_SERVICES, this.getBindServices());
        parameters.addString(CommandLineParameter.COPYRIGHT, this.getCopyright());
        parameters.addString(CommandLineParameter.DESCRIPTION, this.getAppDescription());
        parameters.addFile(CommandLineParameter.DESTINATION, this.getDestination(), false);
        parameters.addFile(CommandLineParameter.ICON, this.getIcon(), true);
        parameters.addFile(CommandLineParameter.INPUT, this.getInput(), true);
        parameters.addString(CommandLineParameter.INSTALL_DIR, this.getInstallDir());
        if (this.getJavaOptions().isPresent()) {
            for (Object option : (List)this.getJavaOptions().get()) {
                parameters.addString(CommandLineParameter.JAVA_OPTIONS, StringUtil.escape(option.toString()));
            }
        }
        if (this.getJLinkOptions().isPresent() && !(jLinkOptions = (List)this.getJLinkOptions().get()).isEmpty()) {
            parameters.addString(CommandLineParameter.JLINK_OPTIONS, String.join((CharSequence)" ", jLinkOptions));
        }
        parameters.addBoolean(CommandLineParameter.LAUNCHER_AS_SERVICE, this.getLauncherAsService());
        parameters.addFile(CommandLineParameter.LICENSE_FILE, this.getLicenseFile(), true);
        parameters.addString(CommandLineParameter.MAIN_CLASS, this.getMainClass());
        parameters.addString(CommandLineParameter.MAIN_JAR, this.getMainJar());
        parameters.addString(CommandLineParameter.MODULE, this.getModule());
        this.getModulePaths().forEach(file -> parameters.addFile(CommandLineParameter.MODULE_PATH, (File)file, true));
        parameters.addString(CommandLineParameter.NAME, this.getAppName());
        parameters.addFile(CommandLineParameter.RESOURCE_DIR, this.getResourceDir(), true);
        parameters.addFile(CommandLineParameter.RUNTIME_IMAGE, this.getRuntimeImage(), true);
        parameters.addFile(CommandLineParameter.TEMP, this.getTemp(), false);
        ImageType type = (ImageType)((Object)this.getType().getOrElse((Object)ImageType.DEFAULT));
        if (type != ImageType.DEFAULT) {
            parameters.addString(CommandLineParameter.TYPE, type.getValue());
        }
        parameters.addString(CommandLineParameter.VENDOR, this.getVendor());
        parameters.addBoolean(CommandLineParameter.VERBOSE, this.getVerbose());
        if (OsUtil.isMac()) {
            parameters.addString(CommandLineParameter.MAC_APP_CATEGORY, this.getMacAppCategory());
            parameters.addBoolean(CommandLineParameter.MAC_APP_STORE, this.getMacAppStore());
            parameters.addString(CommandLineParameter.MAC_BUNDLE_SIGNING_PREFIX, this.getMacBundleSigningPrefix());
            this.getMacDmgContent().forEach(file -> parameters.addFile(CommandLineParameter.MAC_DMG_CONTENT, (File)file, true));
            parameters.addFile(CommandLineParameter.MAC_ENTITLEMENTS, this.getMacEntitlements(), true);
            parameters.addString(CommandLineParameter.MAC_PACKAGE_IDENTIFIER, this.getMacPackageIdentifier());
            parameters.addString(CommandLineParameter.MAC_PACKAGE_NAME, this.getMacPackageName());
            parameters.addString(CommandLineParameter.MAC_PACKAGE_SIGNING_PREFIX, this.getMacBundleSigningPrefix());
            parameters.addBoolean(CommandLineParameter.MAC_SIGN, this.getMacSign());
            parameters.addString(CommandLineParameter.MAC_SIGNING_KEY_USER_NAME, this.getMacSigningKeyUserName());
            parameters.addFile(CommandLineParameter.MAC_SIGNING_KEYCHAIN, this.getMacSigningKeychain(), true);
        } else if (OsUtil.isWindows()) {
            parameters.addBoolean(CommandLineParameter.WIN_CONSOLE, this.getWinConsole());
            parameters.addBoolean(CommandLineParameter.WIN_DIR_CHOOSER, this.getWinDirChooser());
            parameters.addString(CommandLineParameter.WIN_HELP_URL, this.getWinHelpUrl());
            parameters.addBoolean(CommandLineParameter.WIN_MENU, this.getWinMenu());
            parameters.addString(CommandLineParameter.WIN_MENU_GROUP, this.getWinMenuGroup());
            parameters.addBoolean(CommandLineParameter.WIN_PER_USER_INSTALL, this.getWinPerUserInstall());
            parameters.addBoolean(CommandLineParameter.WIN_SHORTCUT, this.getWinShortcut());
            parameters.addBoolean(CommandLineParameter.WIN_SHORTCUT_PROMPT, this.getWinShortcutPrompt());
            parameters.addString(CommandLineParameter.WIN_UPDATE_URL, this.getWinUpdateUrl());
            parameters.addString(CommandLineParameter.WIN_UPGRADE_UUID, this.getWinUpgradeUuid());
        } else if (OsUtil.isLinux()) {
            parameters.addString(CommandLineParameter.LINUX_APP_CATEGORY, this.getLinuxAppCategory());
            parameters.addString(CommandLineParameter.LINUX_APP_RELEASE, this.getLinuxAppRelease());
            parameters.addString(CommandLineParameter.LINUX_DEB_MAINTAINER, this.getLinuxDebMaintainer());
            parameters.addString(CommandLineParameter.LINUX_MENU_GROUP, this.getLinuxMenuGroup());
            parameters.addBoolean(CommandLineParameter.LINUX_PACKAGE_DEPS, this.getLinuxPackageDeps());
            parameters.addString(CommandLineParameter.LINUX_PACKAGE_NAME, this.getLinuxPackageName());
            parameters.addString(CommandLineParameter.LINUX_RPM_LICENSE_TYPE, this.getLinuxRpmLicenseType());
            parameters.addBoolean(CommandLineParameter.LINUX_SHORTCUT, this.getLinuxShortcut());
        }
        if (this.getAdditionalParameters().isPresent()) {
            for (Object option : (List)this.getAdditionalParameters().get()) {
                parameters.add(option.toString());
            }
        }
    }

    private void execute(String cmd) {
        Parameters parameters = new Parameters(this.getLogger(), this.getProjectLayout().getProjectDirectory());
        parameters.add(cmd.contains(" ") ? "\"" + cmd + "\"" : cmd);
        this.buildParameters(parameters);
        if (this.dryRun) {
            return;
        }
        Path destinationPath = ((File)this.getDestination().getAsFile().get()).toPath().toAbsolutePath();
        if (!DirectoryUtil.isNestedDirectory(((File)this.getProjectLayout().getBuildDirectory().getAsFile().get()).toPath(), destinationPath)) {
            this.getLogger().error("Cannot remove destination folder, must belong to {}", this.getProjectLayout().getBuildDirectory().get());
        } else {
            this.getLogger().warn("Trying to remove destination {}", (Object)destinationPath);
            DirectoryUtil.removeDirectory(destinationPath);
        }
        try {
            Map jPackageEnvironment;
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            if (this.getJpackageEnvironment().isPresent() && !(jPackageEnvironment = (Map)this.getJpackageEnvironment().get()).isEmpty()) {
                this.getLogger().info("jpackage environment:");
                Map<String, String> environment = processBuilder.environment();
                for (Map.Entry entry : jPackageEnvironment.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (key == null || key.trim().isEmpty() || value == null) continue;
                    environment.put(key, value);
                    this.getLogger().info("  {} = {}", (Object)key, (Object)value);
                }
            }
            Process process = processBuilder.redirectErrorStream(true).command(parameters.getParams()).start();
            this.getLogger().info("jpackage output:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            Object object = null;
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    this.getLogger().info(line);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
            int status = process.waitFor();
            if (status != 0) {
                throw new GradleException("Error while executing jpackage");
            }
        }
        catch (Exception ex) {
            throw new GradleException("Error while executing jpackage", (Throwable)ex);
        }
    }

    public void windows(Runnable block) {
        if (OsUtil.isWindows()) {
            block.run();
        }
    }

    public void mac(Runnable block) {
        if (OsUtil.isMac()) {
            block.run();
        }
    }

    public void linux(Runnable block) {
        if (OsUtil.isLinux()) {
            block.run();
        }
    }
}

