/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.sahara.internal;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.openstack4j.api.sahara.JobBinaryInternalService;
import org.openstack4j.core.transport.HttpEntityHandler;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.common.Payload;
import org.openstack4j.model.common.Payloads;
import org.openstack4j.model.sahara.JobBinaryInternal;
import org.openstack4j.openstack.sahara.domain.SaharaJobBinaryInternal;
import org.openstack4j.openstack.sahara.internal.BaseSaharaServices;

public class JobBinaryInternalServiceImpl
extends BaseSaharaServices
implements JobBinaryInternalService {
    @Override
    public List<? extends JobBinaryInternal> list() {
        return this.get(SaharaJobBinaryInternal.JobBinaryInternals.class, this.uri("/job-binary-internals", new Object[0])).execute().getList();
    }

    @Override
    public JobBinaryInternal get(String jobBinaryInternalId) {
        Preconditions.checkNotNull((Object)jobBinaryInternalId);
        return this.get(SaharaJobBinaryInternal.class, this.uri("/job-binary-internals/%s", jobBinaryInternalId)).execute();
    }

    @Override
    public ActionResponse delete(String jobBinaryInternalId) {
        Preconditions.checkNotNull((Object)jobBinaryInternalId);
        return this.deleteWithResponse(this.uri("/job-binary-internals/%s", jobBinaryInternalId)).execute();
    }

    @Override
    public JobBinaryInternal create(Payload<File> payload) {
        Preconditions.checkNotNull(payload);
        return this.put(SaharaJobBinaryInternal.class, this.uri("/job-binary-internals/%s", payload.getRaw().getName())).entity(payload).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Payload<InputStream> getData(String jobBinaryInternalId) {
        HttpResponse response = this.get(Void.class, this.uri("/job-binary-internals/%s/data", jobBinaryInternalId)).executeWithResponse();
        try {
            if (response.getStatus() < 400) {
                Payload<InputStream> payload = Payloads.create(response.getInputStream());
                return payload;
            }
            Payload<InputStream> payload = null;
            return payload;
        }
        finally {
            HttpEntityHandler.closeQuietly(response);
        }
    }
}

