/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.network.ext.Ethertype;
import org.openstack4j.model.network.ext.FlowClassifier;
import org.openstack4j.model.network.ext.builder.FlowClassifierBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="flow_classifier")
public class NeutronFlowClassifier
implements FlowClassifier {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty(value="project_id")
    private String projectId;
    @JsonProperty
    private String description;
    @JsonProperty
    private String protocol;
    @JsonProperty(value="source_port_range_min")
    private Integer sourcePortRangeMin;
    @JsonProperty(value="source_port_range_max")
    private Integer sourcePortRangeMax;
    @JsonProperty(value="destination_port_range_min")
    private Integer destinationPortRangeMin;
    @JsonProperty(value="destination_port_range_max")
    private Integer destinationPortRangeMax;
    @JsonProperty(value="source_ip_prefix")
    private String sourceIpPrefix;
    @JsonProperty(value="destination_ip_prefix")
    private String destinationIpPrefix;
    @JsonProperty(value="logical_source_port")
    private String logicalSourcePort;
    @JsonProperty(value="logical_destination_port")
    private String logicalDestinationPort;
    @JsonProperty(value="l7_parameters")
    private Map<String, String> l7Parameters;
    private Ethertype ethertype;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @JsonIgnore
    public String getTenantId() {
        return this.projectId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.projectId = tenantId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public Integer getSourcePortRangeMin() {
        return this.sourcePortRangeMin;
    }

    @Override
    public Integer getSourcePortRangeMax() {
        return this.sourcePortRangeMax;
    }

    @Override
    public Integer getDestinationPortRangeMin() {
        return this.destinationPortRangeMin;
    }

    @Override
    public Integer getDestinationPortRangeMax() {
        return this.destinationPortRangeMax;
    }

    @Override
    public String getSourceIpPrefix() {
        return this.sourceIpPrefix;
    }

    @Override
    public String getDestinationIpPrefix() {
        return this.destinationIpPrefix;
    }

    @Override
    public String getLogicalSourcePort() {
        return this.logicalSourcePort;
    }

    @Override
    public String getLogicalDestinationPort() {
        return this.logicalDestinationPort;
    }

    @Override
    public Map<String, String> getL7Parameters() {
        return this.l7Parameters;
    }

    @Override
    public Ethertype getEthertype() {
        return this.ethertype;
    }

    @Override
    public FlowClassifierBuilder toBuilder() {
        return new FlowClassifierConcreteBuilder(this);
    }

    public static FlowClassifierBuilder builder() {
        return new FlowClassifierConcreteBuilder();
    }

    public static class FlowClassifierConcreteBuilder
    implements FlowClassifierBuilder {
        private NeutronFlowClassifier neutronFlowClassifier;

        public FlowClassifierConcreteBuilder() {
            this.neutronFlowClassifier = new NeutronFlowClassifier();
        }

        public FlowClassifierConcreteBuilder(NeutronFlowClassifier m) {
            this.neutronFlowClassifier = m;
        }

        @Override
        public FlowClassifierBuilder id(String id) {
            this.neutronFlowClassifier.id = id;
            return this;
        }

        @Override
        public FlowClassifierBuilder name(String name) {
            this.neutronFlowClassifier.name = name;
            return this;
        }

        @Override
        public FlowClassifierBuilder projectId(String projectId) {
            this.neutronFlowClassifier.projectId = projectId;
            return this;
        }

        @Override
        public FlowClassifierBuilder description(String description) {
            this.neutronFlowClassifier.description = description;
            return this;
        }

        @Override
        public FlowClassifierBuilder protocol(String protocol) {
            this.neutronFlowClassifier.protocol = protocol;
            return this;
        }

        @Override
        public FlowClassifierBuilder sourcePortRangeMin(Integer sourcePortRangeMin) {
            this.neutronFlowClassifier.sourcePortRangeMin = sourcePortRangeMin;
            return this;
        }

        @Override
        public FlowClassifierBuilder sourcePortRangeMax(Integer sourcePortRangeMax) {
            this.neutronFlowClassifier.sourcePortRangeMax = sourcePortRangeMax;
            return this;
        }

        @Override
        public FlowClassifierBuilder destinationPortRangeMin(Integer destinationPortRangeMin) {
            this.neutronFlowClassifier.destinationPortRangeMin = destinationPortRangeMin;
            return this;
        }

        @Override
        public FlowClassifierBuilder destinationPortRangeMax(Integer destinationPortRangeMax) {
            this.neutronFlowClassifier.destinationPortRangeMax = destinationPortRangeMax;
            return this;
        }

        @Override
        public FlowClassifierBuilder sourceIpPrefix(String sourceIpPrefix) {
            this.neutronFlowClassifier.sourceIpPrefix = sourceIpPrefix;
            return this;
        }

        @Override
        public FlowClassifierBuilder destinationIpPrefix(String destinationIpPrefix) {
            this.neutronFlowClassifier.destinationIpPrefix = destinationIpPrefix;
            return this;
        }

        @Override
        public FlowClassifierBuilder logicalSourcePort(String logicalSourcePort) {
            this.neutronFlowClassifier.logicalSourcePort = logicalSourcePort;
            return this;
        }

        @Override
        public FlowClassifierBuilder logicalDestinationPort(String logicalDestinationPort) {
            this.neutronFlowClassifier.logicalDestinationPort = logicalDestinationPort;
            return this;
        }

        @Override
        public FlowClassifierBuilder l7Parameters(Map<String, String> l7Parameters) {
            this.neutronFlowClassifier.l7Parameters = l7Parameters;
            return this;
        }

        @Override
        public FlowClassifierBuilder ethertype(Ethertype ethertype) {
            this.neutronFlowClassifier.ethertype = ethertype;
            return this;
        }

        @Override
        public FlowClassifier build() {
            return this.neutronFlowClassifier;
        }

        @Override
        public FlowClassifierBuilder from(FlowClassifier in) {
            this.neutronFlowClassifier = (NeutronFlowClassifier)in;
            return this;
        }
    }

    public static class FlowClassifiers
    extends ListResult<NeutronFlowClassifier> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="flow_classifiers")
        private List<NeutronFlowClassifier> flowClassifiers;

        @Override
        public List<NeutronFlowClassifier> value() {
            return this.flowClassifiers;
        }
    }
}

