/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.vertx.http;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.WithContentAction;
import org.pac4j.core.exception.http.WithLocationAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.vertx.VertxWebContext;

public class VertxHttpActionAdapter
implements HttpActionAdapter {
    public static final VertxHttpActionAdapter INSTANCE = new VertxHttpActionAdapter();
    private static final Logger LOG = LoggerFactory.getLogger(VertxHttpActionAdapter.class);

    public Object adapt(HttpAction action, WebContext context) {
        if (action != null) {
            WithContentAction withContentAction;
            String content;
            RoutingContext routingContext = ((VertxWebContext)context).getVertxRoutingContext();
            int code = action.getCode();
            LOG.debug((Object)"Adapting action: {}", new Object[]{code});
            if (code < 400) {
                routingContext.response().setStatusCode(code);
            } else {
                routingContext.fail(code);
            }
            if (action instanceof WithLocationAction) {
                WithLocationAction withLocationAction = (WithLocationAction)action;
                context.setResponseHeader("Location", withLocationAction.getLocation());
                routingContext.response().end();
            } else if (action instanceof WithContentAction && (content = (withContentAction = (WithContentAction)action).getContent()) != null) {
                routingContext.response().setChunked(true);
                routingContext.response().write(content);
                routingContext.response().end();
            }
            return null;
        }
        throw new TechnicalException("No action provided");
    }
}

