/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.vertx.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.FindBest;
import org.pac4j.vertx.VertxProfileManager;
import org.pac4j.vertx.VertxWebContext;
import org.pac4j.vertx.auth.Pac4jAuthProvider;
import org.pac4j.vertx.context.session.VertxSessionStore;
import org.pac4j.vertx.handler.impl.SecurityHandlerOptions;
import org.pac4j.vertx.http.VertxHttpActionAdapter;

public class SecurityHandler
extends AuthenticationHandlerImpl {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityHandler.class);
    protected final Config config;
    protected final String clientNames;
    protected final String authorizerName;
    protected final String matcherName;
    protected final boolean multiProfile;
    protected final Vertx vertx;
    private final SessionStore sessionStore;

    public SecurityHandler(Vertx vertx, SessionStore sessionStore, Config config, Pac4jAuthProvider authProvider, SecurityHandlerOptions options) {
        super((AuthenticationProvider)authProvider);
        CommonHelper.assertNotNull((String)"vertx", (Object)vertx);
        CommonHelper.assertNotNull((String)"sessionStore", (Object)sessionStore);
        CommonHelper.assertNotNull((String)"config", (Object)config);
        CommonHelper.assertNotNull((String)"config.getClients()", (Object)config.getClients());
        CommonHelper.assertNotNull((String)"authProvider", (Object)authProvider);
        CommonHelper.assertNotNull((String)"options", (Object)options);
        this.clientNames = options.getClients();
        this.authorizerName = options.getAuthorizers();
        this.matcherName = options.getMatchers();
        this.multiProfile = options.isMultiProfile();
        this.vertx = vertx;
        this.sessionStore = sessionStore;
        this.config = config;
    }

    public void authenticate(RoutingContext routingContext, Handler<AsyncResult<User>> handler) {
        SecurityLogic bestLogic = FindBest.securityLogic(null, (Config)this.config, (SecurityLogic)DefaultSecurityLogic.INSTANCE);
        HttpActionAdapter bestAdapter = FindBest.httpActionAdapter(null, (Config)this.config, (HttpActionAdapter)VertxHttpActionAdapter.INSTANCE);
        VertxWebContext webContext = new VertxWebContext(routingContext, this.sessionStore);
        this.vertx.executeBlocking(future -> bestLogic.perform((WebContext)webContext, this.sessionStore, this.config, (ctx, store, profiles, parameters) -> {
            future.complete();
            return null;
        }, bestAdapter, this.clientNames, this.authorizerName, this.matcherName, new Object[0]), asyncResult -> {
            if (asyncResult.failed()) {
                this.unexpectedFailure(routingContext, asyncResult.cause());
            } else {
                LOG.info((Object)("Authorised to view resource " + routingContext.request().path()));
                routingContext.next();
            }
        });
    }

    protected void unexpectedFailure(RoutingContext context, Throwable failure) {
        context.fail((Throwable)this.toTechnicalException(failure));
    }

    protected final TechnicalException toTechnicalException(Throwable t) {
        return t instanceof TechnicalException ? (TechnicalException)t : new TechnicalException(t);
    }

    static {
        Config.defaultProfileManagerFactory((String)"VertxProfileManager", (ctx, store) -> new VertxProfileManager((VertxWebContext)ctx, (VertxSessionStore)store));
    }
}

