/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.vertx;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.vertx.auth.Pac4jUser;

public class VertxWebContext
implements WebContext {
    private final RoutingContext routingContext;
    private final String method;
    private final String serverName;
    private final int serverPort;
    private final String fullUrl;
    private final String scheme;
    private final String remoteAddress;
    private final JsonObject headers;
    private final JsonObject parameters;
    private final Map<String, String[]> mapParameters;
    private final SessionStore sessionStore;

    public VertxWebContext(RoutingContext routingContext, SessionStore sessionStore) {
        URI uri;
        HttpServerRequest request = routingContext.request();
        this.routingContext = routingContext;
        this.method = request.method().toString();
        this.sessionStore = sessionStore;
        this.fullUrl = request.absoluteURI();
        try {
            uri = new URI(this.fullUrl);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new InvalidParameterException("Request to invalid URL " + this.fullUrl + " while constructing VertxWebContext");
        }
        this.scheme = uri.getScheme();
        this.serverName = uri.getHost();
        this.serverPort = uri.getPort() != -1 ? uri.getPort() : (this.scheme.equals("http") ? 80 : 443);
        this.remoteAddress = request.remoteAddress().toString();
        this.headers = new JsonObject();
        for (String name : request.headers().names()) {
            this.headers.put(name, (Object)request.headers().get(name));
        }
        this.parameters = new JsonObject();
        for (String name : request.params().names()) {
            this.parameters.put(name, (Object)new JsonArray(Arrays.asList(request.params().getAll(name).toArray())));
        }
        for (String name : request.formAttributes().names()) {
            this.parameters.put(name, (Object)new JsonArray(Arrays.asList(request.formAttributes().getAll(name).toArray())));
        }
        this.mapParameters = new HashMap<String, String[]>();
        for (String name : this.parameters.fieldNames()) {
            JsonArray params = this.parameters.getJsonArray(name);
            String[] values = new String[params.size()];
            int i = 0;
            for (Object o : params) {
                values[i++] = (String)o;
            }
            this.mapParameters.put(name, values);
        }
    }

    public Optional<String> getRequestParameter(String name) {
        JsonArray values = this.parameters.getJsonArray(name);
        if (values != null && values.size() > 0) {
            return Optional.ofNullable(values.getString(0));
        }
        return Optional.empty();
    }

    public Map<String, String[]> getRequestParameters() {
        return this.mapParameters;
    }

    public Optional<Object> getRequestAttribute(String s) {
        return Optional.ofNullable(this.routingContext.get(s));
    }

    public void setRequestAttribute(String s, Object o) {
        this.routingContext.put(s, o);
    }

    public Optional<String> getRequestHeader(String name) {
        return Optional.ofNullable(this.headers.getString(name));
    }

    public String getRequestMethod() {
        return this.method;
    }

    public String getRemoteAddr() {
        return this.remoteAddress;
    }

    public void setResponseHeader(String name, String value) {
        this.routingContext.response().putHeader(name, value);
    }

    public Optional<String> getResponseHeader(String s) {
        return Optional.ofNullable(this.routingContext.response().headers().get(s));
    }

    public Map<String, String> getResponseHeaders() {
        return this.routingContext.response().headers().entries().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void setResponseContentType(String s) {
        this.routingContext.response().headers().add("Content-Type", s);
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isSecure() {
        return this.getScheme().equals("https");
    }

    public String getFullRequestURL() {
        return this.fullUrl;
    }

    public Collection<Cookie> getRequestCookies() {
        return this.routingContext.cookieMap().values().stream().map(cookie -> {
            io.vertx.core.http.Cookie cookie1 = cookie;
            Cookie p4jCookie = new Cookie(cookie.getName(), cookie.getValue());
            p4jCookie.setDomain(cookie.getDomain());
            p4jCookie.setPath(cookie.getPath());
            return p4jCookie;
        }).collect(Collectors.toList());
    }

    public void addResponseCookie(Cookie cookie) {
        io.vertx.core.http.Cookie vertxCookie = io.vertx.core.http.Cookie.cookie((String)cookie.getName(), (String)cookie.getValue()).setHttpOnly(cookie.isHttpOnly()).setSecure(cookie.isSecure()).setDomain(cookie.getDomain()).setPath(cookie.getPath());
        if (cookie.getMaxAge() > 0) {
            vertxCookie.setMaxAge((long)cookie.getMaxAge());
        }
        this.routingContext.addCookie(vertxCookie);
    }

    public String getPath() {
        return this.routingContext.request().path();
    }

    public Pac4jUser getVertxUser() {
        return (Pac4jUser)this.routingContext.user();
    }

    public void removeVertxUser() {
        this.routingContext.clearUser();
    }

    public void setVertxUser(Pac4jUser pac4jUser) {
        this.routingContext.setUser((User)pac4jUser);
    }

    public Session getVertxSession() {
        return this.routingContext.session();
    }

    public RoutingContext getVertxRoutingContext() {
        return this.routingContext;
    }
}

