/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.engine.DefaultCallbackLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.core.util.CommonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CallbackController {
    private CallbackLogic<Object, JEEContext> callbackLogic = new DefaultCallbackLogic();
    @Value(value="${pac4j.callback.defaultUrl:#{null}}")
    private String defaultUrl;
    @Value(value="${pac4j.callback.multiProfile:#{null}}")
    private Boolean multiProfile;
    @Value(value="${pac4j.callback.saveInSession:#{null}}")
    private Boolean saveInSession;
    @Value(value="${pac4j.callback.renewSession:#{null}}")
    private Boolean renewSession;
    @Value(value="${pac4j.callback.defaultClient:#{null}}")
    private String defaultClient;
    @Autowired
    private Config config;

    @RequestMapping(value={"${pac4j.callback.path:/callback}"})
    public void callback(HttpServletRequest request, HttpServletResponse response) {
        CommonHelper.assertNotNull((String)"callbackLogic", this.callbackLogic);
        CommonHelper.assertNotNull((String)"config", (Object)this.config);
        JEEContext context = new JEEContext(request, response, this.config.getSessionStore());
        this.callbackLogic.perform((WebContext)context, this.config, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE, this.defaultUrl, this.saveInSession, this.multiProfile, this.renewSession, this.defaultClient);
    }

    @RequestMapping(value={"${pac4j.callback.path/{cn}:/callback/{cn}}"})
    public void callbackWithClientName(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="cn") String cn) {
        this.callback(request, response);
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public CallbackLogic<Object, JEEContext> getCallbackLogic() {
        return this.callbackLogic;
    }

    public void setCallbackLogic(CallbackLogic<Object, JEEContext> callbackLogic) {
        this.callbackLogic = callbackLogic;
    }

    public Boolean getMultiProfile() {
        return this.multiProfile;
    }

    public void setMultiProfile(Boolean multiProfile) {
        this.multiProfile = multiProfile;
    }

    public Boolean getRenewSession() {
        return this.renewSession;
    }

    public void setRenewSession(Boolean renewSession) {
        this.renewSession = renewSession;
    }

    public String getDefaultClient() {
        return this.defaultClient;
    }

    public void setDefaultClient(String client) {
        this.defaultClient = client;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }
}

