/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.annotation;

import java.util.List;
import org.pac4j.core.authorization.authorizer.IsAuthenticatedAuthorizer;
import org.pac4j.core.authorization.authorizer.RequireAllRolesAuthorizer;
import org.pac4j.core.authorization.authorizer.RequireAnyRoleAuthorizer;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.springframework.beans.factory.annotation.Autowired;

public class CommonAspect {
    private static final IsAuthenticatedAuthorizer IS_AUTHENTICATED_AUTHORIZER = new IsAuthenticatedAuthorizer();
    @Autowired
    private J2EContext webContext;
    @Autowired
    private ProfileManager profileManager;

    protected List<CommonProfile> isAuthenticated(boolean readFromSession) {
        List profiles = this.profileManager.getAll(readFromSession);
        if (!IS_AUTHENTICATED_AUTHORIZER.isAuthorized((WebContext)this.webContext, profiles)) {
            throw HttpAction.unauthorized((WebContext)this.webContext);
        }
        return profiles;
    }

    protected void requireAnyRole(boolean readFromSession, String ... roles) {
        RequireAnyRoleAuthorizer authorizer = new RequireAnyRoleAuthorizer(roles);
        List<CommonProfile> profiles = this.isAuthenticated(readFromSession);
        if (!authorizer.isAuthorized((WebContext)this.webContext, profiles)) {
            throw HttpAction.forbidden((WebContext)this.webContext);
        }
    }

    protected void requireAllRoles(boolean readFromSession, String ... roles) {
        RequireAllRolesAuthorizer authorizer = new RequireAllRolesAuthorizer(roles);
        List<CommonProfile> profiles = this.isAuthenticated(readFromSession);
        if (!authorizer.isAuthorized((WebContext)this.webContext, profiles)) {
            throw HttpAction.forbidden((WebContext)this.webContext);
        }
    }
}

