/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.util.CommonHelper;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class SecurityInterceptor
extends HandlerInterceptorAdapter {
    private SecurityLogic<Boolean, J2EContext> securityLogic = new DefaultSecurityLogic();
    private String clients;
    private String authorizers;
    private String matchers;
    private Boolean multiProfile;
    private Config config;

    public SecurityInterceptor(Config config) {
        this.config = config;
    }

    public SecurityInterceptor(Config config, String clients) {
        this(config);
        this.clients = clients;
    }

    public SecurityInterceptor(Config config, String clients, String authorizers) {
        this(config, clients);
        this.authorizers = authorizers;
    }

    public SecurityInterceptor(Config config, String clients, String authorizers, String matchers) {
        this(config, clients, authorizers);
        this.matchers = matchers;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        CommonHelper.assertNotNull((String)"securityLogic", this.securityLogic);
        CommonHelper.assertNotNull((String)"config", (Object)this.config);
        J2EContext context = new J2EContext(request, response, this.config.getSessionStore());
        return (Boolean)this.securityLogic.perform((WebContext)context, this.config, (context1, profiles, parameters) -> true, (code, webCtx) -> false, this.clients, this.authorizers, this.matchers, this.multiProfile, new Object[0]);
    }

    public SecurityLogic<Boolean, J2EContext> getSecurityLogic() {
        return this.securityLogic;
    }

    public void setSecurityLogic(SecurityLogic<Boolean, J2EContext> securityLogic) {
        this.securityLogic = securityLogic;
    }

    public String getClients() {
        return this.clients;
    }

    public void setClients(String clients) {
        this.clients = clients;
    }

    public String getAuthorizers() {
        return this.authorizers;
    }

    public void setAuthorizers(String authorizers) {
        this.authorizers = authorizers;
    }

    public String getMatchers() {
        return this.matchers;
    }

    public void setMatchers(String matchers) {
        this.matchers = matchers;
    }

    public Boolean getMultiProfile() {
        return this.multiProfile;
    }

    public void setMultiProfile(Boolean multiProfile) {
        this.multiProfile = multiProfile;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }
}

