/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.engine.ApplicationLogoutLogic;
import org.pac4j.core.engine.DefaultApplicationLogoutLogic;
import org.pac4j.core.http.HttpActionAdapter;
import org.pac4j.core.http.J2ENopHttpActionAdapter;
import org.pac4j.core.util.CommonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ApplicationLogoutController {
    private ApplicationLogoutLogic<Object, J2EContext> applicationLogoutLogic = new DefaultApplicationLogoutLogic();
    @Value(value="${pac4j.applicationLogout.defaultUrl:#{null}}")
    private String defaultUrl;
    @Value(value="${pac4j.applicationLogout.logoutUrlPattern:#{null}}")
    private String logoutUrlPattern;
    @Autowired
    private Config config;

    @RequestMapping(value={"/logout"})
    public void applicationLogout(HttpServletRequest request, HttpServletResponse response) {
        CommonHelper.assertNotNull((String)"applicationLogoutLogic", this.applicationLogoutLogic);
        CommonHelper.assertNotNull((String)"config", (Object)this.config);
        J2EContext context = new J2EContext(request, response, this.config.getSessionStore());
        this.applicationLogoutLogic.perform((WebContext)context, this.config, (HttpActionAdapter)J2ENopHttpActionAdapter.INSTANCE, this.defaultUrl, this.logoutUrlPattern);
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public String getLogoutUrlPattern() {
        return this.logoutUrlPattern;
    }

    public void setLogoutUrlPattern(String logoutUrlPattern) {
        this.logoutUrlPattern = logoutUrlPattern;
    }

    public ApplicationLogoutLogic<Object, J2EContext> getApplicationLogoutLogic() {
        return this.applicationLogoutLogic;
    }

    public void setApplicationLogoutLogic(ApplicationLogoutLogic<Object, J2EContext> applicationLogoutLogic) {
        this.applicationLogoutLogic = applicationLogoutLogic;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }
}

