/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.credentials;

import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.NameID;
import org.pac4j.core.credentials.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAML2Credentials
extends Credentials {
    private static final Logger logger = LoggerFactory.getLogger(SAML2Credentials.class);
    private static final long serialVersionUID = 5040516205957826527L;
    private final SAMLNameID nameId;
    private final String sessionIndex;
    private final List<SAMLAttribute> attributes;
    private final SAMLConditions conditions;
    private final String issuerId;
    private final List<String> authnContexts;
    private final String inResponseTo;

    public SAML2Credentials(SAMLNameID nameId, String issuerId, List<SAMLAttribute> samlAttributes, Conditions conditions, String sessionIndex, List<String> authnContexts, String inResponseTo) {
        this.nameId = nameId;
        this.issuerId = issuerId;
        this.sessionIndex = sessionIndex;
        this.attributes = samlAttributes;
        this.inResponseTo = inResponseTo;
        if (conditions != null) {
            this.conditions = new SAMLConditions();
            if (conditions.getNotBefore() != null) {
                this.conditions.setNotBefore(ZonedDateTime.ofInstant(conditions.getNotBefore(), ZoneOffset.UTC));
            }
            if (conditions.getNotOnOrAfter() != null) {
                this.conditions.setNotOnOrAfter(ZonedDateTime.ofInstant(conditions.getNotOnOrAfter(), ZoneOffset.UTC));
            }
        } else {
            this.conditions = null;
        }
        this.authnContexts = authnContexts;
        logger.info("Constructed SAML2 credentials: {}", (Object)this);
    }

    public final SAMLNameID getNameId() {
        return this.nameId;
    }

    public final String getSessionIndex() {
        return this.sessionIndex;
    }

    public final List<SAMLAttribute> getAttributes() {
        return this.attributes;
    }

    public SAMLConditions getConditions() {
        return this.conditions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SAML2Credentials that = (SAML2Credentials)((Object)o);
        if (this.nameId != null ? !this.nameId.equals(that.nameId) : that.nameId != null) {
            return false;
        }
        if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) {
            return false;
        }
        if (this.sessionIndex != null ? this.sessionIndex.equals(that.sessionIndex) : that.sessionIndex != null) {
            return false;
        }
        return !(this.conditions == null ? that.conditions != null : !this.conditions.equals(that.conditions));
    }

    public int hashCode() {
        int result = this.nameId != null ? this.nameId.hashCode() : 0;
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        result = 31 * result + (this.sessionIndex != null ? this.sessionIndex.hashCode() : 0);
        result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SAML2Credentials{nameId=" + this.nameId + ", sessionIndex='" + this.sessionIndex + "', attributes=" + this.attributes + ", conditions=" + this.conditions + ", issuerId='" + this.issuerId + "', authnContexts=" + this.authnContexts + "}";
    }

    public String getIssuerId() {
        return this.issuerId;
    }

    public List<String> getAuthnContexts() {
        return this.authnContexts;
    }

    public String getInResponseTo() {
        return this.inResponseTo;
    }

    public static class SAMLConditions
    implements Serializable {
        private static final long serialVersionUID = -8966585574672014553L;
        private ZonedDateTime notBefore;
        private ZonedDateTime notOnOrAfter;

        public ZonedDateTime getNotBefore() {
            return this.notBefore;
        }

        public void setNotBefore(ZonedDateTime notBefore) {
            this.notBefore = notBefore;
        }

        public ZonedDateTime getNotOnOrAfter() {
            return this.notOnOrAfter;
        }

        public void setNotOnOrAfter(ZonedDateTime notOnOrAfter) {
            this.notOnOrAfter = notOnOrAfter;
        }

        public String toString() {
            return "SAMLConditions{notBefore=" + this.notBefore + ", notOnOrAfter=" + this.notOnOrAfter + "}";
        }
    }

    public static class SAMLAttribute
    implements Serializable {
        private static final long serialVersionUID = 2532838901563948260L;
        private String friendlyName;
        private String name;
        private String nameFormat;
        private List<String> attributeValues = new ArrayList<String>();

        public static SAMLAttribute from(Attribute attribute) {
            SAMLAttribute samlAttribute = new SAMLAttribute();
            samlAttribute.setFriendlyName(attribute.getFriendlyName());
            samlAttribute.setName(attribute.getName());
            samlAttribute.setNameFormat(attribute.getNameFormat());
            attribute.getAttributeValues().stream().map(XMLObject::getDOM).filter(dom -> dom != null && dom.getTextContent() != null).forEach(dom -> samlAttribute.getAttributeValues().add(dom.getTextContent()));
            return samlAttribute;
        }

        public static List<SAMLAttribute> from(List<Attribute> samlAttributes) {
            ArrayList<SAMLAttribute> extractedAttributes = new ArrayList<SAMLAttribute>();
            samlAttributes.forEach(openSamlAttribute -> openSamlAttribute.getAttributeValues().forEach(attributeValue -> {
                boolean isComplexType = attributeValue.hasChildren();
                if (isComplexType) {
                    List<SAMLAttribute> attrs = SAMLAttribute.collectAttributesFromNodeList(attributeValue.getDOM().getChildNodes());
                    extractedAttributes.addAll(attrs);
                } else {
                    extractedAttributes.add(SAMLAttribute.from(openSamlAttribute));
                }
            }));
            return extractedAttributes;
        }

        private static List<SAMLAttribute> collectAttributesFromNodeList(NodeList nodeList) {
            ArrayList<SAMLAttribute> results = new ArrayList<SAMLAttribute>();
            if (nodeList == null) {
                return results;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.hasChildNodes()) {
                    results.addAll(SAMLAttribute.collectAttributesFromNodeList(node.getChildNodes()));
                    continue;
                }
                if (node.getTextContent().isBlank()) continue;
                SAMLAttribute samlAttribute = new SAMLAttribute();
                samlAttribute.setName(node.getParentNode().getLocalName());
                samlAttribute.getAttributeValues().add(node.getTextContent());
                results.add(samlAttribute);
            }
            return results;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNameFormat() {
            return this.nameFormat;
        }

        public void setNameFormat(String nameFormat) {
            this.nameFormat = nameFormat;
        }

        public List<String> getAttributeValues() {
            return this.attributeValues;
        }

        public void setAttributeValues(List<String> attributeValues) {
            this.attributeValues = attributeValues;
        }

        public String toString() {
            return "SAMLAttribute{friendlyName='" + this.friendlyName + "', name='" + this.name + "', nameFormat='" + this.nameFormat + "', attributeValues=" + this.attributeValues + "}";
        }
    }

    public static class SAMLNameID
    implements Serializable {
        private static final long serialVersionUID = -7913473743778305079L;
        private String format;
        private String nameQualifier;
        private String spNameQualifier;
        private String spProviderId;
        private String value;

        public static SAMLNameID from(NameID nameId) {
            SAMLNameID result = new SAMLNameID();
            result.setNameQualifier(nameId.getNameQualifier());
            result.setFormat(nameId.getFormat());
            result.setSpNameQualifier(nameId.getSPNameQualifier());
            result.setSpProviderId(nameId.getSPProvidedID());
            result.setValue(nameId.getValue());
            return result;
        }

        public static SAMLNameID from(SAMLAttribute attribute) {
            SAMLNameID result = new SAMLNameID();
            result.setValue(attribute.getAttributeValues().get(0));
            result.setFormat(attribute.getNameFormat());
            result.setNameQualifier(attribute.getName());
            result.setSpNameQualifier(attribute.getFriendlyName());
            return result;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getSpNameQualifier() {
            return this.spNameQualifier;
        }

        public void setSpNameQualifier(String spNameQualifier) {
            this.spNameQualifier = spNameQualifier;
        }

        public String getSpProviderId() {
            return this.spProviderId;
        }

        public void setSpProviderId(String spProviderId) {
            this.spProviderId = spProviderId;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public String getNameQualifier() {
            return this.nameQualifier;
        }

        public void setNameQualifier(String nameQualifier) {
            this.nameQualifier = nameQualifier;
        }

        public String toString() {
            return "SAMLNameID{format='" + this.format + "', nameQualifier='" + this.nameQualifier + "', spNameQualifier='" + this.spNameQualifier + "', spProviderId='" + this.spProviderId + "', value='" + this.value + "'}";
        }
    }
}

