/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import net.shibboleth.utilities.java.support.net.URIComparator;
import net.shibboleth.utilities.java.support.net.impl.BasicURLComparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.pac4j.core.client.config.BaseClientConfiguration;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.logout.handler.DefaultLogoutHandler;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.crypto.KeyStoreCredentialProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.BaseSAML2MetadataGenerator;
import org.pac4j.saml.metadata.SAML2FileSystemMetadataGenerator;
import org.pac4j.saml.metadata.SAML2HttpUrlMetadataGenerator;
import org.pac4j.saml.metadata.SAML2IdentityProviderMetadataResolver;
import org.pac4j.saml.metadata.SAML2MetadataContactPerson;
import org.pac4j.saml.metadata.SAML2MetadataGenerator;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.metadata.SAML2MetadataSigner;
import org.pac4j.saml.metadata.SAML2MetadataUIInfo;
import org.pac4j.saml.metadata.SAML2ServiceProviderRequestedAttribute;
import org.pac4j.saml.metadata.keystore.SAML2FileSystemKeystoreGenerator;
import org.pac4j.saml.metadata.keystore.SAML2HttpUrlKeystoreGenerator;
import org.pac4j.saml.metadata.keystore.SAML2KeystoreGenerator;
import org.pac4j.saml.sso.impl.SAML2ScopingIdentityProvider;
import org.pac4j.saml.store.EmptyStoreFactory;
import org.pac4j.saml.store.SAMLMessageStoreFactory;
import org.pac4j.saml.util.SAML2HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SAML2Configuration
extends BaseClientConfiguration {
    protected static final String RESOURCE_PREFIX = "resource:";
    protected static final String CLASSPATH_PREFIX = "classpath:";
    protected static final String FILE_PREFIX = "file:";
    protected static final String DEFAULT_PROVIDER_NAME = "pac4j-saml";
    private static final Logger LOGGER = LoggerFactory.getLogger(SAML2Configuration.class);
    private final List<SAML2ScopingIdentityProvider> scopingIdentityProviders = new ArrayList<SAML2ScopingIdentityProvider>();
    private final List<SAML2ServiceProviderRequestedAttribute> requestedServiceProviderAttributes = new ArrayList<SAML2ServiceProviderRequestedAttribute>();
    private HostnameVerifier hostnameVerifier;
    private SSLSocketFactory sslSocketFactory;
    private SAML2MetadataSigner metadataSigner;
    private String singleSignOutServiceUrl;
    private String nameIdAttribute;
    private String callbackUrl;
    private Resource keystoreResource;
    private String keystorePassword;
    private String privateKeyPassword;
    private String certificateNameToAppend;
    private Resource identityProviderMetadataResource;
    private String identityProviderEntityId;
    private String serviceProviderEntityId;
    private long maximumAuthenticationLifetime = 3600L;
    private long acceptedSkew = 300L;
    private boolean forceAuth = false;
    private boolean passive = false;
    private String comparisonType = null;
    private boolean isPartialLogoutTreatedAsSuccess = true;
    private String authnRequestBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private String responseBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private String spLogoutRequestBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private String spLogoutResponseBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private List<String> authnContextClassRefs = new ArrayList<String>();
    private String nameIdPolicyFormat = null;
    private boolean useNameQualifier = false;
    private boolean signMetadata;
    private Resource serviceProviderMetadataResource;
    private boolean forceServiceProviderMetadataGeneration;
    private boolean forceKeystoreGeneration;
    private SAMLMessageStoreFactory samlMessageStoreFactory = new EmptyStoreFactory();
    private SAML2KeystoreGenerator keystoreGenerator;
    private SAML2MetadataGenerator metadataGenerator;
    private boolean authnRequestSigned;
    private boolean spLogoutRequestSigned;
    private Collection<String> blackListedSignatureSigningAlgorithms;
    private List<String> signatureAlgorithms;
    private List<String> signatureReferenceDigestMethods;
    private String signatureCanonicalizationAlgorithm;
    private boolean wantsAssertionsSigned = false;
    private boolean wantsResponsesSigned = false;
    private boolean allSignatureValidationDisabled = false;
    private boolean responseDestinationAttributeMandatory = true;
    private String keyStoreAlias;
    private String keyStoreType;
    private int assertionConsumerServiceIndex = -1;
    private int attributeConsumingServiceIndex = -1;
    private String providerName;
    private Supplier<List<XSAny>> authnRequestExtensions;
    private String attributeAsId;
    private Map<String, String> mappedAttributes = new LinkedHashMap<String, String>();
    private URIComparator uriComparator = new BasicURLComparator();
    private LogoutHandler logoutHandler;
    private String postLogoutURL;
    private Period certificateExpirationPeriod = Period.ofYears(20);
    private String certificateSignatureAlg = "SHA1WithRSA";
    private int privateKeySize = 2048;
    private List<SAML2MetadataContactPerson> contactPersons = new ArrayList<SAML2MetadataContactPerson>();
    private List<SAML2MetadataUIInfo> metadataUIInfos = new ArrayList<SAML2MetadataUIInfo>();
    private String issuerFormat = "urn:oasis:names:tc:SAML:2.0:nameid-format:entity";
    private HttpClient httpClient;
    private Boolean nameIdPolicyAllowCreate = Boolean.TRUE;
    private List<String> supportedProtocols = new ArrayList<String>(Arrays.asList("urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:1.0:protocol", "urn:oasis:names:tc:SAML:1.1:protocol"));
    private SAML2MetadataResolver identityProviderMetadataResolver;

    public SAML2Configuration() {
    }

    public SAML2Configuration(String keystorePath, String keystorePassword, String privateKeyPassword, String identityProviderMetadataPath) {
        this(null, null, SAML2Configuration.mapPathToResource(keystorePath), keystorePassword, privateKeyPassword, SAML2Configuration.mapPathToResource(identityProviderMetadataPath), null, null, DEFAULT_PROVIDER_NAME, null, null);
    }

    public SAML2Configuration(Resource keystoreResource, String keystorePassword, String privateKeyPassword, Resource identityProviderMetadataResource) {
        this(null, null, keystoreResource, keystorePassword, privateKeyPassword, identityProviderMetadataResource, null, null, DEFAULT_PROVIDER_NAME, null, null);
    }

    public SAML2Configuration(Resource keystoreResource, String keyStoreAlias, String keyStoreType, String keystorePassword, String privateKeyPassword, Resource identityProviderMetadataResource) {
        this(keyStoreAlias, keyStoreType, keystoreResource, keystorePassword, privateKeyPassword, identityProviderMetadataResource, null, null, DEFAULT_PROVIDER_NAME, null, null);
    }

    protected SAML2Configuration(String keyStoreAlias, String keyStoreType, Resource keystoreResource, String keystorePassword, String privateKeyPassword, Resource identityProviderMetadataResource, String identityProviderEntityId, String serviceProviderEntityId, String providerName, Supplier<List<XSAny>> authnRequestExtensions, String attributeAsId) {
        this.keyStoreAlias = keyStoreAlias;
        this.keyStoreType = keyStoreType;
        this.keystoreResource = keystoreResource;
        this.keystorePassword = keystorePassword;
        this.privateKeyPassword = privateKeyPassword;
        this.identityProviderMetadataResource = identityProviderMetadataResource;
        this.identityProviderEntityId = identityProviderEntityId;
        this.serviceProviderEntityId = serviceProviderEntityId;
        this.providerName = providerName;
        this.authnRequestExtensions = authnRequestExtensions;
        this.attributeAsId = attributeAsId;
    }

    protected static UrlResource newUrlResource(String url) {
        try {
            return new UrlResource(url);
        }
        catch (MalformedURLException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    private static Resource mapPathToResource(String path) {
        CommonHelper.assertNotBlank((String)"path", (String)path);
        try {
            if (path.startsWith(RESOURCE_PREFIX)) {
                return new ClassPathResource(path.substring(RESOURCE_PREFIX.length()));
            }
            if (path.startsWith(CLASSPATH_PREFIX)) {
                return new ClassPathResource(path.substring(CLASSPATH_PREFIX.length()));
            }
            if (path.startsWith("http") || path.startsWith("https")) {
                return new UrlResource(new URL(path));
            }
            if (path.startsWith(FILE_PREFIX)) {
                return new FileSystemResource(path.substring(FILE_PREFIX.length()));
            }
            return new FileSystemResource(path);
        }
        catch (Exception e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        try {
            if (CommonHelper.isBlank((String)this.getServiceProviderEntityId())) {
                URL url = new URL(callbackUrl);
                if (url.getQuery() != null) {
                    this.setServiceProviderEntityId(url.toString().replace("?" + url.getQuery(), ""));
                } else {
                    this.setServiceProviderEntityId(url.toString());
                }
            }
            LOGGER.info("Using service provider entity ID {}", (Object)this.getServiceProviderEntityId());
        }
        catch (Exception e) {
            throw new SAMLException(e);
        }
    }

    protected void internalInit() {
        SAML2KeystoreGenerator keystoreGenerator = this.getKeystoreGenerator();
        if (keystoreGenerator.shouldGenerate()) {
            LOGGER.warn("Generating keystore one for/via: {}", (Object)this.keystoreResource);
            keystoreGenerator.generate();
        }
        if (this.logoutHandler == null) {
            this.logoutHandler = new DefaultLogoutHandler();
        }
        this.initSignatureSigningConfiguration();
    }

    public SAML2KeystoreGenerator getKeystoreGenerator() {
        if (this.keystoreGenerator == null) {
            if (this.keystoreResource instanceof UrlResource) {
                return new SAML2HttpUrlKeystoreGenerator(this);
            }
            return new SAML2FileSystemKeystoreGenerator(this);
        }
        return this.keystoreGenerator;
    }

    public void setKeystoreGenerator(SAML2KeystoreGenerator keystoreGenerator) {
        this.keystoreGenerator = keystoreGenerator;
    }

    public Boolean isNameIdPolicyAllowCreate() {
        return this.nameIdPolicyAllowCreate;
    }

    public void setNameIdPolicyAllowCreate(Boolean nameIdPolicyAllowCreate) {
        this.nameIdPolicyAllowCreate = nameIdPolicyAllowCreate;
    }

    public List<SAML2MetadataContactPerson> getContactPersons() {
        return this.contactPersons;
    }

    public void setContactPersons(List<SAML2MetadataContactPerson> contactPersons) {
        this.contactPersons = contactPersons;
    }

    public List<SAML2MetadataUIInfo> getMetadataUIInfos() {
        return this.metadataUIInfos;
    }

    public void setMetadataUIInfos(List<SAML2MetadataUIInfo> metadataUIInfos) {
        this.metadataUIInfos = metadataUIInfos;
    }

    public List<String> getSupportedProtocols() {
        return this.supportedProtocols;
    }

    public void setSupportedProtocols(List<String> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }

    public String getCertificateSignatureAlg() {
        return this.certificateSignatureAlg;
    }

    public void setCertificateSignatureAlg(String certificateSignatureAlg) {
        this.certificateSignatureAlg = certificateSignatureAlg;
    }

    public Period getCertificateExpirationPeriod() {
        return this.certificateExpirationPeriod;
    }

    public void setCertificateExpirationPeriod(Period certificateExpirationPeriod) {
        this.certificateExpirationPeriod = certificateExpirationPeriod;
    }

    public int getPrivateKeySize() {
        return this.privateKeySize;
    }

    public void setPrivateKeySize(int privateKeySize) {
        this.privateKeySize = privateKeySize;
    }

    public List<SAML2ScopingIdentityProvider> getScopingIdentityProviders() {
        return this.scopingIdentityProviders;
    }

    public List<SAML2ServiceProviderRequestedAttribute> getRequestedServiceProviderAttributes() {
        return this.requestedServiceProviderAttributes;
    }

    public void setIdentityProviderMetadataResourceFilepath(String path) {
        this.identityProviderMetadataResource = new FileSystemResource(path);
    }

    public void setIdentityProviderMetadataResourceClasspath(String path) {
        this.identityProviderMetadataResource = new ClassPathResource(path);
    }

    public void setIdentityProviderMetadataResourceUrl(String url) {
        this.identityProviderMetadataResource = SAML2Configuration.newUrlResource(url);
    }

    public void setIdentityProviderMetadataPath(String path) {
        this.identityProviderMetadataResource = SAML2Configuration.mapPathToResource(path);
    }

    public int getAssertionConsumerServiceIndex() {
        return this.assertionConsumerServiceIndex;
    }

    public void setAssertionConsumerServiceIndex(int assertionConsumerServiceIndex) {
        this.assertionConsumerServiceIndex = assertionConsumerServiceIndex;
    }

    public boolean isForceKeystoreGeneration() {
        return this.forceKeystoreGeneration;
    }

    public void setForceKeystoreGeneration(boolean forceKeystoreGeneration) {
        this.forceKeystoreGeneration = forceKeystoreGeneration;
    }

    public long getAcceptedSkew() {
        return this.acceptedSkew;
    }

    public void setAcceptedSkew(long acceptedSkew) {
        this.acceptedSkew = acceptedSkew;
    }

    public Resource getIdentityProviderMetadataResource() {
        return this.identityProviderMetadataResource;
    }

    public void setIdentityProviderMetadataResource(Resource identityProviderMetadataResource) {
        this.identityProviderMetadataResource = identityProviderMetadataResource;
    }

    public String getIdentityProviderEntityId() {
        return this.identityProviderEntityId;
    }

    public void setIdentityProviderEntityId(String identityProviderEntityId) {
        this.identityProviderEntityId = identityProviderEntityId;
    }

    public void setKeystoreAlias(String keyStoreAlias) {
        this.keyStoreAlias = keyStoreAlias;
    }

    public void setKeystoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setKeystoreResourceFilepath(String path) {
        this.keystoreResource = new FileSystemResource(path);
    }

    public void setKeystoreResourceClasspath(String path) {
        this.keystoreResource = new ClassPathResource(path);
    }

    public void setKeystoreResourceUrl(String url) {
        this.keystoreResource = SAML2Configuration.mapPathToResource(url);
    }

    public void setKeystorePath(String path) {
        this.keystoreResource = SAML2Configuration.mapPathToResource(path);
    }

    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public Resource getKeystoreResource() {
        return this.keystoreResource;
    }

    public void setKeystoreResource(Resource keystoreResource) {
        this.keystoreResource = keystoreResource;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public String getCertificateNameToAppend() {
        return this.certificateNameToAppend;
    }

    public void setCertificateNameToAppend(String certificateNameToAppend) {
        this.certificateNameToAppend = certificateNameToAppend;
    }

    public void setServiceProviderMetadataResourceFilepath(String path) {
        this.serviceProviderMetadataResource = new FileSystemResource(path);
    }

    public void setServiceProviderMetadataPath(String path) {
        this.serviceProviderMetadataResource = SAML2Configuration.mapPathToResource(path);
    }

    public Resource getServiceProviderMetadataResource() {
        return this.serviceProviderMetadataResource;
    }

    public void setServiceProviderMetadataResource(Resource serviceProviderMetadataResource) {
        this.serviceProviderMetadataResource = serviceProviderMetadataResource;
    }

    public String getServiceProviderEntityId() {
        return this.serviceProviderEntityId;
    }

    public void setServiceProviderEntityId(String serviceProviderEntityId) {
        this.serviceProviderEntityId = serviceProviderEntityId;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public boolean isForceAuth() {
        return this.forceAuth;
    }

    public void setForceAuth(boolean forceAuth) {
        this.forceAuth = forceAuth;
    }

    public String getComparisonType() {
        return this.comparisonType;
    }

    public void setComparisonType(String comparisonType) {
        this.comparisonType = comparisonType;
    }

    public String getAuthnRequestBindingType() {
        return this.authnRequestBindingType;
    }

    public void setAuthnRequestBindingType(String authnRequestBindingType) {
        this.authnRequestBindingType = authnRequestBindingType;
    }

    public String getResponseBindingType() {
        return this.responseBindingType;
    }

    public void setResponseBindingType(String responseBindingType) {
        this.responseBindingType = responseBindingType;
    }

    public String getSpLogoutRequestBindingType() {
        return this.spLogoutRequestBindingType;
    }

    public void setSpLogoutRequestBindingType(String spLogoutRequestBindingType) {
        this.spLogoutRequestBindingType = spLogoutRequestBindingType;
    }

    public String getSpLogoutResponseBindingType() {
        return this.spLogoutResponseBindingType;
    }

    public void setSpLogoutResponseBindingType(String spLogoutResponseBindingType) {
        this.spLogoutResponseBindingType = spLogoutResponseBindingType;
    }

    public List<String> getAuthnContextClassRefs() {
        return this.authnContextClassRefs;
    }

    public void setAuthnContextClassRefs(List<String> authnContextClassRefs) {
        this.authnContextClassRefs = authnContextClassRefs;
    }

    public URIComparator getUriComparator() {
        return this.uriComparator;
    }

    public void setUriComparator(URIComparator uriComparator) {
        this.uriComparator = uriComparator;
    }

    public String getNameIdPolicyFormat() {
        return this.nameIdPolicyFormat;
    }

    public void setNameIdPolicyFormat(String nameIdPolicyFormat) {
        this.nameIdPolicyFormat = nameIdPolicyFormat;
    }

    public long getMaximumAuthenticationLifetime() {
        return this.maximumAuthenticationLifetime;
    }

    public void setMaximumAuthenticationLifetime(long maximumAuthenticationLifetime) {
        this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
    }

    public boolean isForceServiceProviderMetadataGeneration() {
        return this.forceServiceProviderMetadataGeneration;
    }

    public void setForceServiceProviderMetadataGeneration(boolean forceServiceProviderMetadataGeneration) {
        this.forceServiceProviderMetadataGeneration = forceServiceProviderMetadataGeneration;
    }

    public SAMLMessageStoreFactory getSamlMessageStoreFactory() {
        return this.samlMessageStoreFactory;
    }

    public void setSamlMessageStoreFactory(SAMLMessageStoreFactory samlMessageStoreFactory) {
        this.samlMessageStoreFactory = samlMessageStoreFactory;
    }

    public Collection<String> getBlackListedSignatureSigningAlgorithms() {
        return this.blackListedSignatureSigningAlgorithms;
    }

    public void setBlackListedSignatureSigningAlgorithms(Collection<String> blackListedSignatureSigningAlgorithms) {
        this.blackListedSignatureSigningAlgorithms = blackListedSignatureSigningAlgorithms;
    }

    public List<String> getSignatureAlgorithms() {
        return this.signatureAlgorithms;
    }

    public void setSignatureAlgorithms(List<String> signatureAlgorithms) {
        this.signatureAlgorithms = signatureAlgorithms;
    }

    public List<String> getSignatureReferenceDigestMethods() {
        return this.signatureReferenceDigestMethods;
    }

    public void setSignatureReferenceDigestMethods(List<String> signatureReferenceDigestMethods) {
        this.signatureReferenceDigestMethods = signatureReferenceDigestMethods;
    }

    public String getSignatureCanonicalizationAlgorithm() {
        return this.signatureCanonicalizationAlgorithm;
    }

    public void setSignatureCanonicalizationAlgorithm(String signatureCanonicalizationAlgorithm) {
        this.signatureCanonicalizationAlgorithm = signatureCanonicalizationAlgorithm;
    }

    public boolean isWantsAssertionsSigned() {
        return this.wantsAssertionsSigned;
    }

    public void setWantsAssertionsSigned(boolean wantsAssertionsSigned) {
        this.wantsAssertionsSigned = wantsAssertionsSigned;
    }

    public boolean isWantsResponsesSigned() {
        return this.wantsResponsesSigned;
    }

    public void setWantsResponsesSigned(boolean wantsResponsesSigned) {
        this.wantsResponsesSigned = wantsResponsesSigned;
    }

    public boolean isAuthnRequestSigned() {
        return this.authnRequestSigned;
    }

    public void setAuthnRequestSigned(boolean authnRequestSigned) {
        this.authnRequestSigned = authnRequestSigned;
    }

    public boolean isSpLogoutRequestSigned() {
        return this.spLogoutRequestSigned;
    }

    public void setSpLogoutRequestSigned(boolean spLogoutRequestSigned) {
        this.spLogoutRequestSigned = spLogoutRequestSigned;
    }

    public boolean isAllSignatureValidationDisabled() {
        return this.allSignatureValidationDisabled;
    }

    public void setAllSignatureValidationDisabled(boolean allSignatureValidationDisabled) {
        this.allSignatureValidationDisabled = allSignatureValidationDisabled;
    }

    public void setResponseDestinationAttributeMandatory(boolean mandatory) {
        this.responseDestinationAttributeMandatory = mandatory;
    }

    public boolean isResponseDestinationAttributeMandatory() {
        return this.responseDestinationAttributeMandatory;
    }

    public int getAttributeConsumingServiceIndex() {
        return this.attributeConsumingServiceIndex;
    }

    public void setAttributeConsumingServiceIndex(int attributeConsumingServiceIndex) {
        this.attributeConsumingServiceIndex = attributeConsumingServiceIndex;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public Supplier<List<XSAny>> getAuthnRequestExtensions() {
        return this.authnRequestExtensions;
    }

    public void setAuthnRequestExtensions(Supplier<List<XSAny>> authnRequestExtensions) {
        this.authnRequestExtensions = authnRequestExtensions;
    }

    public SAML2MetadataSigner getMetadataSigner() {
        return this.metadataSigner;
    }

    public void setMetadataSigner(SAML2MetadataSigner metadataSigner) {
        this.metadataSigner = metadataSigner;
    }

    public String getAttributeAsId() {
        return this.attributeAsId;
    }

    public void setAttributeAsId(String attributeAsId) {
        this.attributeAsId = attributeAsId;
    }

    public boolean isUseNameQualifier() {
        return this.useNameQualifier;
    }

    public void setUseNameQualifier(boolean useNameQualifier) {
        this.useNameQualifier = useNameQualifier;
    }

    public boolean isSignMetadata() {
        return this.signMetadata;
    }

    public void setSignMetadata(boolean signMetadata) {
        this.signMetadata = signMetadata;
    }

    public Map<String, String> getMappedAttributes() {
        return this.mappedAttributes;
    }

    public void setMappedAttributes(Map<String, String> mappedAttributes) {
        this.mappedAttributes = mappedAttributes;
    }

    public LogoutHandler getLogoutHandler() {
        return this.logoutHandler;
    }

    public void setLogoutHandler(LogoutHandler logoutHandler) {
        this.logoutHandler = logoutHandler;
    }

    public String getPostLogoutURL() {
        return this.postLogoutURL;
    }

    public void setPostLogoutURL(String postLogoutURL) {
        this.postLogoutURL = postLogoutURL;
    }

    public String getNameIdAttribute() {
        return this.nameIdAttribute;
    }

    public void setNameIdAttribute(String nameIdAttribute) {
        this.nameIdAttribute = nameIdAttribute;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public LogoutHandler findLogoutHandler() {
        this.init();
        return this.logoutHandler;
    }

    private void initSignatureSigningConfiguration() {
        BasicSignatureSigningConfiguration config = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration();
        if (this.blackListedSignatureSigningAlgorithms == null) {
            this.blackListedSignatureSigningAlgorithms = new ArrayList<String>(config.getExcludedAlgorithms());
            LOGGER.info("Bootstrapped Blacklisted Algorithms");
        }
        if (this.signatureAlgorithms == null) {
            this.signatureAlgorithms = new ArrayList<String>(config.getSignatureAlgorithms());
            LOGGER.info("Bootstrapped Signature Algorithms");
        }
        if (this.signatureReferenceDigestMethods == null) {
            this.signatureReferenceDigestMethods = new ArrayList<String>(config.getSignatureReferenceDigestMethods());
            this.signatureReferenceDigestMethods.remove("http://www.w3.org/2001/04/xmlenc#sha512");
            LOGGER.info("Bootstrapped Signature Reference Digest Methods");
        }
        if (this.signatureCanonicalizationAlgorithm == null) {
            this.signatureCanonicalizationAlgorithm = config.getSignatureCanonicalizationAlgorithm();
            LOGGER.info("Bootstrapped Canonicalization Algorithm");
        }
    }

    public String getIssuerFormat() {
        return this.issuerFormat;
    }

    public void setIssuerFormat(String issuerFormat) {
        this.issuerFormat = issuerFormat;
    }

    public String getSingleSignOutServiceUrl() {
        return this.singleSignOutServiceUrl;
    }

    public void setSingleSignOutServiceUrl(String singleSignOutServiceUrl) {
        this.singleSignOutServiceUrl = singleSignOutServiceUrl;
    }

    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = new SAML2HttpClientBuilder().build();
        }
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public CredentialProvider getCredentialProvider() {
        return new KeyStoreCredentialProvider(this);
    }

    public SAML2MetadataGenerator toMetadataGenerator() {
        try {
            SAML2MetadataGenerator instance = this.getMetadataGenerator();
            if (instance instanceof BaseSAML2MetadataGenerator) {
                BaseSAML2MetadataGenerator generator = (BaseSAML2MetadataGenerator)instance;
                generator.setWantAssertionSigned(this.isWantsAssertionsSigned());
                generator.setAuthnRequestSigned(this.isAuthnRequestSigned());
                generator.setSignMetadata(this.isSignMetadata());
                generator.setNameIdPolicyFormat(this.getNameIdPolicyFormat());
                generator.setRequestedAttributes(this.getRequestedServiceProviderAttributes());
                generator.setCredentialProvider(this.getCredentialProvider());
                generator.setMetadataSigner(this.getMetadataSigner());
                generator.setEntityId(this.getServiceProviderEntityId());
                generator.setRequestInitiatorLocation(this.callbackUrl);
                generator.setAssertionConsumerServiceUrl(this.callbackUrl);
                generator.setResponseBindingType(this.getResponseBindingType());
                this.determineSingleSignOutServiceUrl(generator);
                if (this.getBlackListedSignatureSigningAlgorithms() != null) {
                    generator.setBlackListedSignatureSigningAlgorithms(new ArrayList<String>(this.getBlackListedSignatureSigningAlgorithms()));
                }
                generator.setSignatureAlgorithms(this.getSignatureAlgorithms());
                generator.setSignatureReferenceDigestMethods(this.getSignatureReferenceDigestMethods());
                generator.setSupportedProtocols(this.getSupportedProtocols());
                generator.setContactPersons(this.getContactPersons());
                generator.setMetadataUIInfos(this.getMetadataUIInfos());
            }
            return instance;
        }
        catch (Exception e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected void determineSingleSignOutServiceUrl(BaseSAML2MetadataGenerator generator) {
        String url = (String)StringUtils.defaultIfBlank((CharSequence)this.singleSignOutServiceUrl, (CharSequence)this.callbackUrl);
        String logoutUrl = CommonHelper.addParameter((String)url, (String)"logoutendpoint", (String)"true");
        generator.setSingleLogoutServiceUrl(logoutUrl);
    }

    public SAML2MetadataGenerator getMetadataGenerator() throws Exception {
        if (this.metadataGenerator == null) {
            return this.serviceProviderMetadataResource instanceof UrlResource ? new SAML2HttpUrlMetadataGenerator(this.serviceProviderMetadataResource.getURL(), this.getHttpClient()) : new SAML2FileSystemMetadataGenerator();
        }
        return this.metadataGenerator;
    }

    public void setMetadataGenerator(SAML2MetadataGenerator metadataGenerator) {
        this.metadataGenerator = metadataGenerator;
    }

    public SAML2MetadataResolver getIdentityProviderMetadataResolver() {
        if (this.identityProviderMetadataResolver == null) {
            return new SAML2IdentityProviderMetadataResolver(this);
        }
        return this.identityProviderMetadataResolver;
    }

    public void setIdentityProviderMetadataResolver(SAML2MetadataResolver identityProviderMetadataResolver) {
        this.identityProviderMetadataResolver = identityProviderMetadataResolver;
    }

    public boolean isPartialLogoutTreatedAsSuccess() {
        return this.isPartialLogoutTreatedAsSuccess;
    }

    public void setPartialLogoutTreatedAsSuccess(boolean partialLogoutTreatedAsSuccess) {
        this.isPartialLogoutTreatedAsSuccess = partialLogoutTreatedAsSuccess;
    }
}

