/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.logout.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.shibboleth.utilities.java.support.net.URIComparator;
import org.apache.commons.lang3.StringUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.http.FoundAction;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.OkAction;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.crypto.SAML2SignatureTrustEngineProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.profile.impl.AbstractSAML2ResponseValidator;
import org.pac4j.saml.replay.ReplayCacheProvider;
import org.pac4j.saml.util.Configuration;

public class SAML2LogoutValidator
extends AbstractSAML2ResponseValidator {
    private String postLogoutURL;
    private boolean actionOnSuccess = true;
    private boolean isPartialLogoutTreatedAsSuccess = false;
    private String expectedDestination;

    public SAML2LogoutValidator(SAML2SignatureTrustEngineProvider engine, Decrypter decrypter, LogoutHandler logoutHandler, String postLogoutURL, ReplayCacheProvider replayCache, URIComparator uriComparator) {
        super(engine, decrypter, logoutHandler, replayCache, uriComparator);
        this.postLogoutURL = postLogoutURL;
    }

    @Override
    public Credentials validate(SAML2MessageContext context) {
        SAMLObject message = (SAMLObject)context.getMessageContext().getMessage();
        if (message instanceof LogoutRequest) {
            LogoutRequest logoutRequest = (LogoutRequest)message;
            SignatureTrustEngine engine = this.signatureTrustEngineProvider.build();
            this.validateLogoutRequest(logoutRequest, context, engine);
            return null;
        }
        if (message instanceof LogoutResponse) {
            LogoutResponse logoutResponse = (LogoutResponse)message;
            SignatureTrustEngine engine = this.signatureTrustEngineProvider.build();
            this.validateLogoutResponse(logoutResponse, context, engine);
            HttpAction action = this.handlePostLogoutResponse(context);
            if (action != null) {
                throw action;
            }
            return null;
        }
        throw new SAMLException("SAML message must be a LogoutRequest or LogoutResponse type");
    }

    protected HttpAction handlePostLogoutResponse(SAML2MessageContext context) {
        if (StringUtils.isNotBlank((CharSequence)this.postLogoutURL)) {
            return new FoundAction(this.postLogoutURL);
        }
        return this.actionOnSuccess ? new OkAction("") : null;
    }

    protected void validateLogoutRequest(LogoutRequest logoutRequest, SAML2MessageContext context, SignatureTrustEngine engine) {
        String sloKey;
        SessionIndex sessionIndexObject;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Validating logout request:\n{}", (Object)Configuration.serializeSamlObject((XMLObject)logoutRequest));
        }
        this.validateSignatureIfItExists(logoutRequest.getSignature(), context, engine);
        this.validateIssuerIfItExists(logoutRequest.getIssuer(), context);
        NameID nameId = logoutRequest.getNameID();
        EncryptedID encryptedID = logoutRequest.getEncryptedID();
        if (encryptedID != null) {
            nameId = this.decryptEncryptedId(encryptedID, this.decrypter);
        }
        SAML2Credentials.SAMLNameID samlNameId = SAML2Credentials.SAMLNameID.from(nameId);
        String sessionIndex = null;
        List sessionIndexes = logoutRequest.getSessionIndexes();
        if (sessionIndexes != null && !sessionIndexes.isEmpty() && (sessionIndexObject = (SessionIndex)sessionIndexes.get(0)) != null) {
            sessionIndex = sessionIndexObject.getValue();
        }
        if ((sloKey = this.computeSloKey(sessionIndex, samlNameId)) != null) {
            String bindingUri = context.getSAMLBindingContext().getBindingUri();
            this.logger.debug("Using SLO key {} as the session index with the binding uri {}", (Object)sloKey, (Object)bindingUri);
            if ("urn:oasis:names:tc:SAML:2.0:bindings:SOAP".equals(bindingUri)) {
                this.logoutHandler.destroySessionBack(context.getWebContext(), context.getSessionStore(), sloKey);
            } else {
                this.logoutHandler.destroySessionFront(context.getWebContext(), context.getSessionStore(), sloKey);
            }
        }
    }

    protected void validateLogoutResponse(LogoutResponse logoutResponse, SAML2MessageContext context, SignatureTrustEngine engine) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Validating logout response:\n{}", (Object)Configuration.serializeSamlObject((XMLObject)logoutResponse));
        }
        this.validateSuccess(logoutResponse.getStatus());
        this.validateSignatureIfItExists(logoutResponse.getSignature(), context, engine);
        this.validateIssueInstant(logoutResponse.getIssueInstant());
        this.validateIssuerIfItExists(logoutResponse.getIssuer(), context);
        this.validateDestinationEndpoint(logoutResponse, context);
    }

    protected void validateDestinationEndpoint(LogoutResponse logoutResponse, SAML2MessageContext context) {
        ArrayList<String> expected = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)this.expectedDestination)) {
            Endpoint endpoint = (Endpoint)Objects.requireNonNull((SingleLogoutService)context.getSPSSODescriptor().getSingleLogoutServices().get(0));
            if (endpoint.getLocation() != null) {
                expected.add(endpoint.getLocation());
            }
            if (endpoint.getResponseLocation() != null) {
                expected.add(endpoint.getResponseLocation());
            }
        } else {
            expected.add(this.expectedDestination);
        }
        boolean isDestinationMandatory = context.getSAML2Configuration().isResponseDestinationAttributeMandatory();
        this.verifyEndpoint(expected, logoutResponse.getDestination(), isDestinationMandatory);
    }

    @Override
    protected void validateSuccess(Status status) {
        if ("urn:oasis:names:tc:SAML:2.0:status:PartialLogout".equals(status.getStatusCode().getValue()) && this.isPartialLogoutTreatedAsSuccess) {
            this.logger.debug("Response status code is {} and partial logouts are configured to be treated as success => validation successful!", (Object)"urn:oasis:names:tc:SAML:2.0:status:PartialLogout");
            return;
        }
        super.validateSuccess(status);
    }

    public void setActionOnSuccess(boolean actionOnSuccess) {
        this.actionOnSuccess = actionOnSuccess;
    }

    public void setPostLogoutURL(String postLogoutURL) {
        this.postLogoutURL = postLogoutURL;
    }

    public void setExpectedDestination(String expectedDestination) {
        this.expectedDestination = expectedDestination;
    }

    public void setIsPartialLogoutTreatedAsSuccess(boolean isPartialLogoutTreatedAsSuccess) {
        this.isPartialLogoutTreatedAsSuccess = isPartialLogoutTreatedAsSuccess;
    }

    public String getPostLogoutURL() {
        return this.postLogoutURL;
    }

    public boolean isActionOnSuccess() {
        return this.actionOnSuccess;
    }

    public String getExpectedDestination() {
        return this.expectedDestination;
    }
}

