/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso.impl;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.profile.SAML2Profile;
import org.pac4j.saml.util.Configuration;
import org.pac4j.saml.util.SAML2Utils;

public class SAML2LogoutRequestBuilder {
    private String bindingType;
    private int issueInstantSkewSeconds = 0;
    private final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();

    public SAML2LogoutRequestBuilder(String bindingType) {
        this.bindingType = bindingType;
    }

    public LogoutRequest build(SAML2MessageContext context, SAML2Profile profile) {
        SingleLogoutService ssoService = context.getIDPSingleLogoutService(this.bindingType);
        return this.buildLogoutRequest(context, ssoService, profile);
    }

    protected final LogoutRequest buildLogoutRequest(SAML2MessageContext context, SingleLogoutService ssoService, SAML2Profile profile) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(LogoutRequest.DEFAULT_ELEMENT_NAME);
        LogoutRequest request = (LogoutRequest)builder.buildObject();
        SAMLSelfEntityContext selfContext = context.getSAMLSelfEntityContext();
        request.setID(SAML2Utils.generateID());
        request.setIssuer(this.getIssuer(selfContext.getEntityId()));
        request.setIssueInstant(DateTime.now((DateTimeZone)DateTimeZone.UTC).plusSeconds(this.issueInstantSkewSeconds));
        request.setVersion(SAMLVersion.VERSION_20);
        request.setDestination(ssoService.getLocation());
        SAMLObjectBuilder nameIdBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(NameID.DEFAULT_ELEMENT_NAME);
        NameID nameId = (NameID)nameIdBuilder.buildObject();
        nameId.setValue(profile.getId());
        nameId.setFormat(profile.getSamlNameIdFormat());
        nameId.setNameQualifier(profile.getSamlNameIdNameQualifier());
        nameId.setSPNameQualifier(profile.getSamlNameIdSpNameQualifier());
        nameId.setSPProvidedID(profile.getSamlNameIdSpProviderId());
        request.setNameID(nameId);
        String sessIdx = (String)profile.getAttribute("sessionindex");
        SAMLObjectBuilder sessionIndexBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(SessionIndex.DEFAULT_ELEMENT_NAME);
        SessionIndex sessionIdx = (SessionIndex)sessionIndexBuilder.buildObject();
        sessionIdx.setSessionIndex(sessIdx);
        request.getSessionIndexes().add(sessionIdx);
        return request;
    }

    protected final Issuer getIssuer(String spEntityId) {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(spEntityId);
        return issuer;
    }

    public void setIssueInstantSkewSeconds(int issueInstantSkewSeconds) {
        this.issueInstantSkewSeconds = issueInstantSkewSeconds;
    }
}

