/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso.impl;

import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.shibboleth.utilities.java.support.net.BasicURLComparator;
import net.shibboleth.utilities.java.support.net.URIComparator;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.BaseID;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.EncryptedAttribute;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.crypto.SAML2SignatureTrustEngineProvider;
import org.pac4j.saml.exceptions.SAMAssertionSubjectException;
import org.pac4j.saml.exceptions.SAMLAssertionAudienceException;
import org.pac4j.saml.exceptions.SAMLAssertionConditionException;
import org.pac4j.saml.exceptions.SAMLAuthnInstantException;
import org.pac4j.saml.exceptions.SAMLAuthnSessionCriteriaException;
import org.pac4j.saml.exceptions.SAMLEndpointMismatchException;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.exceptions.SAMLInResponseToMismatchException;
import org.pac4j.saml.exceptions.SAMLIssueInstantException;
import org.pac4j.saml.exceptions.SAMLIssuerException;
import org.pac4j.saml.exceptions.SAMLNameIdDecryptionException;
import org.pac4j.saml.exceptions.SAMLSignatureRequiredException;
import org.pac4j.saml.exceptions.SAMLSignatureValidationException;
import org.pac4j.saml.exceptions.SAMLSubjectConfirmationException;
import org.pac4j.saml.sso.SAML2ResponseValidator;
import org.pac4j.saml.storage.SAMLMessageStorage;
import org.pac4j.saml.util.SAML2Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2DefaultResponseValidator
implements SAML2ResponseValidator {
    private static final Logger logger = LoggerFactory.getLogger(SAML2DefaultResponseValidator.class);
    private int acceptedSkew;
    private int maximumAuthenticationLifetime;
    private final boolean wantsAssertionsSigned;
    private final SAML2SignatureTrustEngineProvider signatureTrustEngineProvider;
    private final Decrypter decrypter;
    private final URIComparator uriComparator;

    public SAML2DefaultResponseValidator(SAML2SignatureTrustEngineProvider engine, Decrypter decrypter, int maximumAuthenticationLifetime, boolean wantsAssertionsSigned) {
        this(engine, decrypter, maximumAuthenticationLifetime, wantsAssertionsSigned, (URIComparator)new BasicURLComparator());
    }

    public SAML2DefaultResponseValidator(SAML2SignatureTrustEngineProvider engine, Decrypter decrypter, int maximumAuthenticationLifetime, boolean wantsAssertionsSigned, URIComparator uriComparator) {
        this.signatureTrustEngineProvider = engine;
        this.decrypter = decrypter;
        this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
        this.uriComparator = uriComparator;
        this.wantsAssertionsSigned = wantsAssertionsSigned;
    }

    @Override
    public Credentials validate(SAML2MessageContext context) {
        SAMLObject message = (SAMLObject)context.getMessage();
        if (!(message instanceof Response)) {
            throw new SAMLException("Response instance is an unsupported type");
        }
        Response response = (Response)message;
        SignatureTrustEngine engine = this.signatureTrustEngineProvider.build();
        this.validateSamlProtocolResponse(response, context, engine);
        if (this.decrypter != null) {
            this.decryptEncryptedAssertions(response, this.decrypter);
        }
        this.validateSamlSSOResponse(response, context, engine, this.decrypter);
        return this.buildSAML2Credentials(context);
    }

    protected final SAML2Credentials buildSAML2Credentials(SAML2MessageContext context) {
        NameID nameId = context.getSAMLSubjectNameIdentifierContext().getSAML2SubjectNameID();
        Assertion subjectAssertion = context.getSubjectAssertion();
        String sessionIndex = this.getSessionIndex(subjectAssertion);
        String issuerEntityId = subjectAssertion.getIssuer().getValue();
        List authnStatements = subjectAssertion.getAuthnStatements();
        ArrayList<String> authnContexts = new ArrayList<String>();
        for (AuthnStatement authnStatement : authnStatements) {
            if (authnStatement.getAuthnContext().getAuthnContextClassRef() == null) continue;
            authnContexts.add(authnStatement.getAuthnContext().getAuthnContextClassRef().getAuthnContextClassRef());
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (AttributeStatement attributeStatement : subjectAssertion.getAttributeStatements()) {
            for (Attribute attribute : attributeStatement.getAttributes()) {
                attributes.add(attribute);
            }
            if (attributeStatement.getEncryptedAttributes().isEmpty()) continue;
            if (this.decrypter == null) {
                logger.warn("Encrypted attributes returned, but no keystore was provided.");
                continue;
            }
            for (EncryptedAttribute encryptedAttribute : attributeStatement.getEncryptedAttributes()) {
                try {
                    attributes.add(this.decrypter.decrypt(encryptedAttribute));
                }
                catch (DecryptionException e) {
                    logger.warn("Decryption of attribute failed, continue with the next one", (Throwable)e);
                }
            }
        }
        return new SAML2Credentials(nameId, issuerEntityId, attributes, subjectAssertion.getConditions(), sessionIndex, authnContexts);
    }

    private String getSessionIndex(Assertion subjectAssertion) {
        AuthnStatement statement;
        List authnStatements = subjectAssertion.getAuthnStatements();
        if (authnStatements != null && authnStatements.size() > 0 && (statement = (AuthnStatement)authnStatements.get(0)) != null) {
            return statement.getSessionIndex();
        }
        return null;
    }

    protected final void validateSamlProtocolResponse(Response response, SAML2MessageContext context, SignatureTrustEngine engine) {
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(response.getStatus().getStatusCode().getValue())) {
            String status = response.getStatus().getStatusCode().getValue();
            if (response.getStatus().getStatusMessage() != null) {
                status = status + " / " + response.getStatus().getStatusMessage().getMessage();
            }
            throw new SAMLException("Authentication response is not success ; actual " + status);
        }
        if (response.getSignature() != null) {
            String entityId = context.getSAMLPeerEntityContext().getEntityId();
            this.validateSignature(response.getSignature(), entityId, engine);
            context.getSAMLPeerEntityContext().setAuthenticated(true);
        }
        if (!this.isIssueInstantValid(response.getIssueInstant())) {
            throw new SAMLIssueInstantException("Response issue instant is too old or in the future");
        }
        AuthnRequest request = null;
        SAMLMessageStorage messageStorage = context.getSAMLMessageStorage();
        if (messageStorage != null && response.getInResponseTo() != null) {
            XMLObject xmlObject = messageStorage.retrieveMessage(response.getInResponseTo());
            if (xmlObject == null) {
                throw new SAMLInResponseToMismatchException("InResponseToField of the Response doesn't correspond to sent message " + response.getInResponseTo());
            }
            if (xmlObject instanceof AuthnRequest) {
                request = (AuthnRequest)xmlObject;
            } else {
                throw new SAMLInResponseToMismatchException("Sent request was of different type than the expected AuthnRequest " + response.getInResponseTo());
            }
        }
        this.verifyEndpoint(context.getSAMLEndpointContext().getEndpoint(), response.getDestination());
        if (request != null) {
            this.verifyRequest(request, context);
        }
        if (response.getIssuer() != null) {
            this.validateIssuer(response.getIssuer(), context);
        }
    }

    protected void verifyRequest(AuthnRequest request, SAML2MessageContext context) {
        AssertionConsumerService assertionConsumerService = (AssertionConsumerService)context.getSAMLEndpointContext().getEndpoint();
        if (request.getAssertionConsumerServiceIndex() != null) {
            if (!request.getAssertionConsumerServiceIndex().equals(assertionConsumerService.getIndex())) {
                logger.warn("Response was received at a different endpoint index than was requested");
            }
        } else {
            String responseLocation;
            String requestedResponseURL = request.getAssertionConsumerServiceURL();
            String requestedBinding = request.getProtocolBinding();
            if (requestedResponseURL != null && !requestedResponseURL.equals(responseLocation = assertionConsumerService.getResponseLocation() != null ? assertionConsumerService.getResponseLocation() : assertionConsumerService.getLocation())) {
                logger.warn("Response was received at a different endpoint URL {} than was requested {}", (Object)responseLocation, (Object)requestedResponseURL);
            }
            if (requestedBinding != null && !requestedBinding.equals(context.getSAMLBindingContext().getBindingUri())) {
                logger.warn("Response was received using a different binding {} than was requested {}", (Object)context.getSAMLBindingContext().getBindingUri(), (Object)requestedBinding);
            }
        }
    }

    protected final void verifyEndpoint(Endpoint endpoint, String destination) {
        try {
            if (destination != null && !this.uriComparator.compare(destination, endpoint.getLocation()) && !this.uriComparator.compare(destination, endpoint.getResponseLocation())) {
                throw new SAMLEndpointMismatchException("Intended destination " + destination + " doesn't match any of the endpoint URLs on endpoint " + endpoint.getLocation());
            }
        }
        catch (Exception e) {
            throw new SAMLEndpointMismatchException(e);
        }
    }

    protected final void validateSamlSSOResponse(Response response, SAML2MessageContext context, SignatureTrustEngine engine, Decrypter decrypter) {
        ArrayList<SAMLException> errors = new ArrayList<SAMLException>();
        for (Assertion assertion : response.getAssertions()) {
            if (assertion.getAuthnStatements().isEmpty()) continue;
            try {
                this.validateAssertion(assertion, context, engine, decrypter);
            }
            catch (SAMLException e) {
                logger.error("Current assertion validation failed, continue with the next one", (Throwable)((Object)e));
                errors.add(e);
                continue;
            }
            context.setSubjectAssertion(assertion);
            break;
        }
        if (!errors.isEmpty()) {
            throw (SAMLException)((Object)errors.get(0));
        }
        if (context.getSubjectAssertion() == null) {
            throw new SAMAssertionSubjectException("No valid subject assertion found in response");
        }
        List<SubjectConfirmation> subjectConfirmations = context.getSubjectConfirmations();
        NameID nameIdentifier = (NameID)context.getSAMLSubjectNameIdentifierContext().getSubjectNameIdentifier();
        if (!(nameIdentifier != null && nameIdentifier.getValue() != null || context.getBaseID() != null || subjectConfirmations != null && !subjectConfirmations.isEmpty())) {
            throw new SAMLException("Subject NameID, BaseID and EncryptedID cannot be all null at the same time if there are no Subject Confirmations.");
        }
    }

    protected final void decryptEncryptedAssertions(Response response, Decrypter decrypter) {
        for (EncryptedAssertion encryptedAssertion : response.getEncryptedAssertions()) {
            try {
                Assertion decryptedAssertion = decrypter.decrypt(encryptedAssertion);
                response.getAssertions().add(decryptedAssertion);
            }
            catch (DecryptionException e) {
                logger.error("Decryption of assertion failed, continue with the next one", (Throwable)e);
            }
        }
    }

    protected final void validateIssuer(Issuer issuer, SAML2MessageContext context) {
        if (issuer.getFormat() != null && !issuer.getFormat().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            throw new SAMLIssuerException("Issuer type is not entity but " + issuer.getFormat());
        }
        String entityId = context.getSAMLPeerEntityContext().getEntityId();
        if (entityId == null || !entityId.equals(issuer.getValue())) {
            throw new SAMLIssuerException("Issuer " + issuer.getValue() + " does not match idp entityId " + entityId);
        }
    }

    protected final void validateAssertion(Assertion assertion, SAML2MessageContext context, SignatureTrustEngine engine, Decrypter decrypter) {
        if (!this.isIssueInstantValid(assertion.getIssueInstant())) {
            throw new SAMLIssueInstantException("Assertion issue instant is too old or in the future");
        }
        this.validateIssuer(assertion.getIssuer(), context);
        if (assertion.getSubject() == null) {
            throw new SAMAssertionSubjectException("Assertion subject cannot be null");
        }
        this.validateSubject(assertion.getSubject(), context, decrypter);
        this.validateAssertionConditions(assertion.getConditions(), context);
        this.validateAuthenticationStatements(assertion.getAuthnStatements(), context);
        this.validateAssertionSignature(assertion.getSignature(), context, engine);
    }

    protected final void validateSubject(Subject subject, SAML2MessageContext context, Decrypter decrypter) {
        boolean samlIDFound = false;
        NameID nameIdFromSubject = subject.getNameID();
        BaseID baseIdFromSubject = subject.getBaseID();
        EncryptedID encryptedIdFromSubject = subject.getEncryptedID();
        NameID decryptedNameIdFromSubject = this.decryptEncryptedId(encryptedIdFromSubject, decrypter);
        if (decryptedNameIdFromSubject != null) {
            nameIdFromSubject = decryptedNameIdFromSubject;
        }
        if (nameIdFromSubject != null || baseIdFromSubject != null) {
            context.getSAMLSubjectNameIdentifierContext().setSubjectNameIdentifier((SAMLObject)nameIdFromSubject);
            context.setBaseID(baseIdFromSubject);
            samlIDFound = true;
        }
        for (SubjectConfirmation confirmation : subject.getSubjectConfirmations()) {
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(confirmation.getMethod()) || !this.isValidBearerSubjectConfirmationData(confirmation.getSubjectConfirmationData(), context)) continue;
            NameID nameIDFromConfirmation = confirmation.getNameID();
            BaseID baseIDFromConfirmation = confirmation.getBaseID();
            EncryptedID encryptedIDFromConfirmation = confirmation.getEncryptedID();
            NameID decryptedNameIdFromConfirmation = this.decryptEncryptedId(encryptedIDFromConfirmation, decrypter);
            if (decryptedNameIdFromConfirmation != null) {
                nameIDFromConfirmation = decryptedNameIdFromConfirmation;
            }
            if (!(samlIDFound || nameIDFromConfirmation == null && baseIDFromConfirmation == null)) {
                context.getSAMLSubjectNameIdentifierContext().setSubjectNameIdentifier((SAMLObject)nameIDFromConfirmation);
                context.setBaseID(baseIDFromConfirmation);
                context.getSubjectConfirmations().add(confirmation);
                samlIDFound = true;
            }
            if (!samlIDFound) {
                logger.warn("Could not find any Subject NameID/BaseID/EncryptedID, neither directly in the Subject nor in any Subject Confirmation.");
            }
            return;
        }
        throw new SAMLSubjectConfirmationException("Subject confirmation validation failed");
    }

    protected final NameID decryptEncryptedId(EncryptedID encryptedId, Decrypter decrypter) throws SAMLException {
        if (encryptedId == null) {
            return null;
        }
        if (decrypter == null) {
            logger.warn("Encrypted attributes returned, but no keystore was provided.");
            return null;
        }
        try {
            NameID decryptedId = (NameID)decrypter.decrypt(encryptedId);
            return decryptedId;
        }
        catch (DecryptionException e) {
            throw new SAMLNameIdDecryptionException("Decryption of an EncryptedID failed.", e);
        }
    }

    protected final boolean isValidBearerSubjectConfirmationData(SubjectConfirmationData data, SAML2MessageContext context) {
        if (data == null) {
            logger.debug("SubjectConfirmationData cannot be null for Bearer confirmation");
            return false;
        }
        if (data.getNotBefore() != null) {
            logger.debug("SubjectConfirmationData notBefore must be null for Bearer confirmation");
            return false;
        }
        if (data.getNotOnOrAfter() == null) {
            logger.debug("SubjectConfirmationData notOnOrAfter cannot be null for Bearer confirmation");
            return false;
        }
        if (data.getNotOnOrAfter().plusSeconds(this.acceptedSkew).isBeforeNow()) {
            logger.debug("SubjectConfirmationData notOnOrAfter is too old");
            return false;
        }
        try {
            URI appEndpointUri;
            if (data.getRecipient() == null) {
                logger.debug("SubjectConfirmationData recipient cannot be null for Bearer confirmation");
                return false;
            }
            Endpoint endpoint = context.getSAMLEndpointContext().getEndpoint();
            if (endpoint == null) {
                logger.warn("No endpoint was found in the SAML endpoint context");
                return false;
            }
            URI recipientUri = new URI(data.getRecipient());
            if (!SAML2Utils.urisEqualAfterPortNormalization(recipientUri, appEndpointUri = new URI(endpoint.getLocation()))) {
                logger.debug("SubjectConfirmationData recipient {} does not match SP assertion consumer URL, found. SP ACS URL from context: {}", (Object)recipientUri, (Object)appEndpointUri);
                return false;
            }
        }
        catch (URISyntaxException use) {
            logger.error("Unable to check SubjectConfirmationData recipient, a URI has invalid syntax.", (Throwable)use);
            return false;
        }
        return true;
    }

    protected final void validateAssertionConditions(Conditions conditions, SAML2MessageContext context) {
        if (conditions == null) {
            return;
        }
        if (conditions.getNotBefore() != null && conditions.getNotBefore().minusSeconds(this.acceptedSkew).isAfterNow()) {
            throw new SAMLAssertionConditionException("Assertion condition notBefore is not valid");
        }
        if (conditions.getNotOnOrAfter() != null && conditions.getNotOnOrAfter().plusSeconds(this.acceptedSkew).isBeforeNow()) {
            throw new SAMLAssertionConditionException("Assertion condition notOnOrAfter is not valid");
        }
        String entityId = context.getSAMLSelfEntityContext().getEntityId();
        this.validateAudienceRestrictions(conditions.getAudienceRestrictions(), entityId);
    }

    protected final void validateAudienceRestrictions(List<AudienceRestriction> audienceRestrictions, String spEntityId) {
        if (audienceRestrictions == null || audienceRestrictions.isEmpty()) {
            throw new SAMLAssertionAudienceException("Audience restrictions cannot be null or empty");
        }
        HashSet<String> audienceUris = new HashSet<String>();
        for (AudienceRestriction audienceRestriction : audienceRestrictions) {
            if (audienceRestriction.getAudiences() == null) continue;
            for (Audience audience : audienceRestriction.getAudiences()) {
                audienceUris.add(audience.getAudienceURI());
            }
        }
        if (!audienceUris.contains(spEntityId)) {
            throw new SAMLAssertionAudienceException("Assertion audience " + audienceUris + " does not match SP configuration " + spEntityId);
        }
    }

    protected final void validateAuthenticationStatements(List<AuthnStatement> authnStatements, SAML2MessageContext context) {
        for (AuthnStatement statement : authnStatements) {
            if (!this.isAuthnInstantValid(statement.getAuthnInstant())) {
                throw new SAMLAuthnInstantException("Authentication issue instant is too old or in the future");
            }
            if (statement.getSessionNotOnOrAfter() == null || !statement.getSessionNotOnOrAfter().isBeforeNow()) continue;
            throw new SAMLAuthnSessionCriteriaException("Authentication session between IDP and subject has ended");
        }
    }

    protected final void validateAssertionSignature(Signature signature, SAML2MessageContext context, SignatureTrustEngine engine) {
        SAMLPeerEntityContext peerContext = context.getSAMLPeerEntityContext();
        if (signature != null) {
            String entityId = peerContext.getEntityId();
            this.validateSignature(signature, entityId, engine);
        } else if (this.wantsAssertionsSigned(context).booleanValue() && !peerContext.isAuthenticated()) {
            throw new SAMLSignatureRequiredException("Assertion or response must be signed");
        }
    }

    @VisibleForTesting
    Boolean wantsAssertionsSigned(SAML2MessageContext context) {
        if (context == null) {
            return this.wantsAssertionsSigned;
        }
        SPSSODescriptor spDescriptor = context.getSPSSODescriptor();
        if (spDescriptor == null) {
            return this.wantsAssertionsSigned;
        }
        return spDescriptor.getWantAssertionsSigned();
    }

    protected final void validateSignature(Signature signature, String idpEntityId, SignatureTrustEngine trustEngine) {
        boolean valid;
        SAMLSignatureProfileValidator validator = new SAMLSignatureProfileValidator();
        try {
            validator.validate(signature);
        }
        catch (SignatureException e) {
            throw new SAMLSignatureValidationException("SAMLSignatureProfileValidator failed to validate signature", e);
        }
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        criteriaSet.add((Object)new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol"));
        criteriaSet.add((Object)new EntityIdCriterion(idpEntityId));
        try {
            valid = trustEngine.validate((Object)signature, criteriaSet);
        }
        catch (SecurityException e) {
            throw new SAMLSignatureValidationException("An error occurred during signature validation", e);
        }
        if (!valid) {
            throw new SAMLSignatureValidationException("Signature is not trusted");
        }
    }

    private boolean isDateValid(DateTime issueInstant, int interval) {
        boolean isDateValid;
        DateTime now = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        DateTime before = now.plusSeconds(this.acceptedSkew);
        DateTime after = now.minusSeconds(this.acceptedSkew + interval);
        DateTime issueInstanceUtc = issueInstant.toDateTime(DateTimeZone.UTC);
        boolean bl = isDateValid = issueInstanceUtc.isBefore((ReadableInstant)before) && issueInstanceUtc.isAfter((ReadableInstant)after);
        if (!isDateValid) {
            logger.warn("interval={},before={},after={},issueInstant={}", new Object[]{interval, before.toDateTime(issueInstanceUtc.getZone()), after.toDateTime(issueInstanceUtc.getZone()), issueInstanceUtc});
        }
        return isDateValid;
    }

    private boolean isIssueInstantValid(DateTime issueInstant) {
        return this.isDateValid(issueInstant, 0);
    }

    private boolean isAuthnInstantValid(DateTime authnInstant) {
        return this.isDateValid(authnInstant, this.maximumAuthenticationLifetime);
    }

    @Override
    public final void setAcceptedSkew(int acceptedSkew) {
        this.acceptedSkew = acceptedSkew;
    }

    @Override
    public final void setMaximumAuthenticationLifetime(int maximumAuthenticationLifetime) {
        this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
    }
}

