/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.redirect;

import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import java.util.HashMap;
import java.util.Map;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.redirect.RedirectActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;
import org.pac4j.oidc.config.OidcConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcRedirectActionBuilder
extends InitializableWebObject
implements RedirectActionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(OidcRedirectActionBuilder.class);
    private OidcConfiguration configuration;
    private Map<String, String> authParams;

    public OidcRedirectActionBuilder() {
    }

    public OidcRedirectActionBuilder(OidcConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.configuration.init(context);
        this.authParams = new HashMap<String, String>();
        String scope = this.configuration.getScope();
        if (CommonHelper.isNotBlank((String)scope)) {
            this.authParams.put("scope", scope);
        } else {
            this.authParams.put("scope", "openid profile email");
        }
        String responseType = this.configuration.getResponseType();
        if (CommonHelper.isNotBlank((String)responseType)) {
            this.authParams.put("response_type", responseType);
        } else {
            this.authParams.put("response_type", "code");
        }
        String responseMode = this.configuration.getResponseMode();
        if (CommonHelper.isNotBlank((String)responseMode)) {
            this.authParams.put("response_mode", responseMode);
        }
        this.authParams.put("redirect_uri", this.configuration.getCallbackUrl());
        this.authParams.putAll(this.configuration.getCustomParams());
        this.authParams.put("client_id", this.configuration.getClientId());
    }

    public RedirectAction redirect(WebContext context) throws HttpAction {
        this.init(context);
        Map<String, String> params = this.buildParams();
        this.addStateAndNonceParameters(context, params);
        String location = this.buildAuthenticationRequestUrl(params);
        logger.debug("Authentication request url: {}", (Object)location);
        return RedirectAction.redirect((String)location);
    }

    protected Map<String, String> buildParams() {
        return new HashMap<String, String>(this.authParams);
    }

    protected void addStateAndNonceParameters(WebContext context, Map<String, String> params) {
        State state = new State();
        params.put("state", state.getValue());
        context.setSessionAttribute("oidcStateAttribute", (Object)state);
        if (this.configuration.isUseNonce()) {
            Nonce nonce = new Nonce();
            params.put("nonce", nonce.getValue());
            context.setSessionAttribute("oidcNonceAttribute", (Object)nonce.getValue());
        }
    }

    protected String buildAuthenticationRequestUrl(Map<String, String> params) {
        String queryString;
        try {
            queryString = AuthenticationRequest.parse(params).toQueryString();
        }
        catch (Exception e) {
            throw new TechnicalException((Throwable)e);
        }
        return this.configuration.getProviderMetadata().getAuthorizationEndpointURI().toString() + "?" + queryString;
    }

    public OidcConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OidcConfiguration configuration) {
        this.configuration = configuration;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"configuration", this.configuration});
    }
}

