/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.profile.creator;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.creator.AbstractProfileCreator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.pac4j.oidc.profile.OidcProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcProfileCreator<U extends OidcProfile>
extends AbstractProfileCreator<OidcCredentials, U> {
    private static final Logger logger = LoggerFactory.getLogger(OidcProfileCreator.class);
    private OidcConfiguration configuration;
    protected IDTokenValidator idTokenValidator;

    public OidcProfileCreator() {
    }

    public OidcProfileCreator(OidcConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void internalInit(WebContext context) {
        JWSAlgorithm jwsAlgorithm;
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.configuration.init(context);
        List metadataAlgorithms = this.configuration.getProviderMetadata().getIDTokenJWSAlgs();
        CommonHelper.assertTrue((boolean)CommonHelper.isNotEmpty((Collection)metadataAlgorithms), (String)"There must at least one JWS algorithm supported on the OpenID Connect provider side");
        JWSAlgorithm preferredAlgorithm = this.configuration.getPreferredJwsAlgorithm();
        if (metadataAlgorithms.contains(preferredAlgorithm)) {
            jwsAlgorithm = preferredAlgorithm;
        } else {
            jwsAlgorithm = (JWSAlgorithm)metadataAlgorithms.get(0);
            logger.warn("Preferred JWS algorithm: {} not available. Defaulting to: {}", (Object)preferredAlgorithm, (Object)jwsAlgorithm);
        }
        if ("none".equals(jwsAlgorithm.getName())) {
            jwsAlgorithm = null;
        }
        ClientID _clientID = new ClientID(this.configuration.getClientId());
        Secret _secret = new Secret(this.configuration.getSecret());
        this.idTokenValidator = jwsAlgorithm == null ? new IDTokenValidator(this.configuration.getProviderMetadata().getIssuer(), _clientID) : (CommonHelper.isNotBlank((String)this.configuration.getSecret()) && (JWSAlgorithm.HS256.equals((Object)jwsAlgorithm) || JWSAlgorithm.HS384.equals((Object)jwsAlgorithm) || JWSAlgorithm.HS512.equals((Object)jwsAlgorithm)) ? this.createHMACTokenValidator(jwsAlgorithm, _clientID, _secret) : this.createRSATokenValidator(jwsAlgorithm, _clientID));
        this.idTokenValidator.setMaxClockSkew(this.configuration.getMaxClockSkew());
        this.setProfileFactory(() -> new OidcProfile());
    }

    protected IDTokenValidator createRSATokenValidator(JWSAlgorithm jwsAlgorithm, ClientID clientID) {
        try {
            return new IDTokenValidator(this.configuration.getProviderMetadata().getIssuer(), clientID, jwsAlgorithm, this.configuration.getProviderMetadata().getJWKSetURI().toURL(), this.configuration.getResourceRetriever());
        }
        catch (MalformedURLException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected IDTokenValidator createHMACTokenValidator(JWSAlgorithm jwsAlgorithm, ClientID clientID, Secret secret) {
        return new IDTokenValidator(this.configuration.getProviderMetadata().getIssuer(), clientID, jwsAlgorithm, secret);
    }

    public U create(OidcCredentials credentials, WebContext context) throws HttpAction {
        this.init(context);
        AccessToken accessToken = credentials.getAccessToken();
        OidcProfile profile = (OidcProfile)((Object)this.getProfileFactory().get());
        profile.setAccessToken(accessToken);
        JWT idToken = credentials.getIdToken();
        profile.setIdTokenString(idToken.getParsedString());
        RefreshToken refreshToken = credentials.getRefreshToken();
        if (refreshToken != null && !refreshToken.getValue().isEmpty()) {
            profile.setRefreshToken(refreshToken);
            logger.debug("Refresh Token successful retrieved");
        }
        try {
            Nonce nonce = this.configuration.isUseNonce() ? new Nonce((String)context.getSessionAttribute("oidcNonceAttribute")) : null;
            IDTokenClaimsSet claimsSet = this.idTokenValidator.validate(idToken, nonce);
            CommonHelper.assertNotNull((String)"claimsSet", (Object)claimsSet);
            profile.setId(claimsSet.getSubject());
            if (this.configuration.getProviderMetadata().getUserInfoEndpointURI() != null && accessToken != null) {
                UserInfoRequest userInfoRequest = new UserInfoRequest(this.configuration.getProviderMetadata().getUserInfoEndpointURI(), (BearerAccessToken)accessToken);
                HTTPRequest userInfoHttpRequest = userInfoRequest.toHTTPRequest();
                userInfoHttpRequest.setConnectTimeout(this.configuration.getConnectTimeout());
                userInfoHttpRequest.setReadTimeout(this.configuration.getReadTimeout());
                HTTPResponse httpResponse = userInfoHttpRequest.send();
                logger.debug("Token response: status={}, content={}", (Object)httpResponse.getStatusCode(), (Object)httpResponse.getContent());
                UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponse);
                if (userInfoResponse instanceof UserInfoErrorResponse) {
                    logger.error("Bad User Info response, error={}", (Object)((UserInfoErrorResponse)userInfoResponse).getErrorObject());
                } else {
                    UserInfoSuccessResponse userInfoSuccessResponse = (UserInfoSuccessResponse)userInfoResponse;
                    UserInfo userInfo = userInfoSuccessResponse.getUserInfo();
                    if (userInfo != null) {
                        profile.addAttributes(userInfo.toJWTClaimsSet().getClaims());
                    }
                }
            }
            for (Map.Entry entry : idToken.getJWTClaimsSet().getClaims().entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (profile.getAttribute(key) != null) continue;
                profile.addAttribute(key, value);
            }
            return (U)((Object)profile);
        }
        catch (JOSEException | BadJOSEException | ParseException | IOException | java.text.ParseException e) {
            throw new TechnicalException(e);
        }
    }

    public OidcConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OidcConfiguration configuration) {
        this.configuration = configuration;
    }

    public IDTokenValidator getIdTokenValidator() {
        return this.idTokenValidator;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"configuration", this.configuration});
    }
}

