/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.client;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import java.util.Map;
import org.pac4j.core.client.IndirectClientV2;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.pac4j.oidc.credentials.authenticator.OidcAuthenticator;
import org.pac4j.oidc.credentials.extractor.OidcExtractor;
import org.pac4j.oidc.profile.OidcProfile;
import org.pac4j.oidc.profile.creator.OidcProfileCreator;
import org.pac4j.oidc.redirect.OidcRedirectActionBuilder;

public class OidcClient<U extends OidcProfile>
extends IndirectClientV2<OidcCredentials, U> {
    private OidcConfiguration configuration = new OidcConfiguration();

    public OidcClient() {
    }

    public OidcClient(OidcConfiguration oidcConfiguration) {
        this.configuration = oidcConfiguration;
    }

    public OidcConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OidcConfiguration oidcConfiguration) {
        this.configuration = oidcConfiguration;
    }

    @Deprecated
    public OidcClient(String clientId, String secret, String discoveryURI) {
        this.configuration.setClientId(clientId);
        this.configuration.setSecret(secret);
        this.configuration.setDiscoveryURI(discoveryURI);
    }

    @Deprecated
    public void setDiscoveryURI(String discoveryURI) {
        this.configuration.setDiscoveryURI(discoveryURI);
    }

    @Deprecated
    public void setClientID(String clientId) {
        this.configuration.setClientId(clientId);
    }

    @Deprecated
    public void setSecret(String secret) {
        this.configuration.setSecret(secret);
    }

    @Deprecated
    public void setScope(String scope) {
        this.configuration.setScope(scope);
    }

    @Deprecated
    public void addCustomParam(String key, String value) {
        this.configuration.addCustomParam(key, value);
    }

    @Deprecated
    public void setCustomParams(Map<String, String> customParams) {
        this.configuration.setCustomParams(customParams);
    }

    protected void internalInit(WebContext context) {
        super.internalInit(context);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.configuration.setCallbackUrl(this.computeFinalCallbackUrl(context));
        this.configuration.init(context);
        this.setRedirectActionBuilder(new OidcRedirectActionBuilder(this.configuration));
        this.setCredentialsExtractor(new OidcExtractor(this.configuration, this.getName()));
        this.setAuthenticator(new OidcAuthenticator(this.configuration));
        this.createProfileCreator();
    }

    protected void createProfileCreator() {
        this.setProfileCreator((ProfileCreator)new OidcProfileCreator(this.configuration));
    }

    @Deprecated
    public void setPreferredJwsAlgorithm(JWSAlgorithm preferredJwsAlgorithm) {
        this.configuration.setPreferredJwsAlgorithm(preferredJwsAlgorithm);
    }

    @Deprecated
    public void setUseNonce(boolean useNonce) {
        this.configuration.setUseNonce(useNonce);
    }

    @Deprecated
    public void setClientAuthenticationMethod(ClientAuthenticationMethod clientAuthenticationMethod) {
        this.configuration.setClientAuthenticationMethod(clientAuthenticationMethod);
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "callbackUrl", this.callbackUrl, "callbackUrlResolver", this.callbackUrlResolver, "ajaxRequestResolver", this.getAjaxRequestResolver(), "redirectActionBuilder", this.getRedirectActionBuilder(), "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "configuration", this.configuration});
    }
}

