/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.credentials.authenticator;

import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.credentials.OAuth20Credentials;
import org.pac4j.oauth.credentials.authenticator.OAuthAuthenticator;

public class OAuth20Authenticator
extends OAuthAuthenticator {
    public OAuth20Authenticator(OAuth20Configuration configuration, IndirectClient client) {
        super(configuration, client);
    }

    @Override
    protected void retrieveAccessToken(WebContext context, Credentials credentials) {
        OAuth2AccessToken accessToken;
        OAuth20Credentials oAuth20Credentials = (OAuth20Credentials)credentials;
        String code = oAuth20Credentials.getCode();
        this.logger.debug("code: {}", (Object)code);
        try {
            accessToken = ((OAuth20Service)this.configuration.buildService(context, this.client)).getAccessToken(code);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new HttpCommunicationException("Error getting token:" + e.getMessage());
        }
        this.logger.debug("accessToken: {}", (Object)accessToken);
        oAuth20Credentials.setAccessToken(accessToken);
    }
}

