/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.creator;

import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.oauth.OAuthService;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.credentials.OAuth20Credentials;
import org.pac4j.oauth.profile.OAuth20Profile;
import org.pac4j.oauth.profile.creator.OAuthProfileCreator;

public class OAuth20ProfileCreator
extends OAuthProfileCreator {
    public OAuth20ProfileCreator(OAuth20Configuration configuration, IndirectClient client) {
        super(configuration, client);
    }

    protected OAuth2AccessToken getAccessToken(Credentials credentials) {
        return ((OAuth20Credentials)credentials).getAccessToken();
    }

    @Override
    protected void addAccessTokenToProfile(UserProfile profile, Token tok) {
        if (profile != null) {
            String token = ((OAuth2AccessToken)tok).getAccessToken();
            this.logger.debug("add access_token: {} to profile", (Object)token);
            ((OAuth20Profile)profile).setAccessToken(token);
        }
    }

    @Override
    protected void signRequest(OAuthService service, Token token, OAuthRequest request) {
        ((OAuth20Service)service).signRequest((OAuth2AccessToken)token, request);
        String accessToken = ((OAuth2AccessToken)token).getAccessToken();
        if (this.configuration.isTokenAsHeader()) {
            request.addHeader("Authorization", "Bearer " + accessToken);
        }
        if (Verb.POST.equals((Object)request.getVerb())) {
            request.addParameter("oauth_token", accessToken);
        }
    }
}

