/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.yahoo;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.OAuth1Token;
import java.util.Arrays;
import java.util.List;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.core.profile.converter.DateConverter;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.converter.JsonConverter;
import org.pac4j.oauth.profile.definition.OAuth10ProfileDefinition;
import org.pac4j.oauth.profile.yahoo.YahooAddress;
import org.pac4j.oauth.profile.yahoo.YahooDisclosure;
import org.pac4j.oauth.profile.yahoo.YahooEmail;
import org.pac4j.oauth.profile.yahoo.YahooImage;
import org.pac4j.oauth.profile.yahoo.YahooInterest;
import org.pac4j.oauth.profile.yahoo.YahooProfile;

public class YahooProfileDefinition
extends OAuth10ProfileDefinition<YahooProfile> {
    public static final String ABOUT_ME = "aboutMe";
    public static final String AGE_CATEGORY = "ageCategory";
    public static final String ADDRESSES = "addresses";
    public static final String BIRTH_YEAR = "birthYear";
    public static final String BIRTHDATE = "birthdate";
    public static final String CREATED = "created";
    public static final String DISPLAY_AGE = "displayAge";
    public static final String DISCLOSURES = "disclosures";
    public static final String EMAILS = "emails";
    public static final String FAMILY_NAME = "familyName";
    public static final String GIVEN_NAME = "givenName";
    public static final String IMAGE = "image";
    public static final String INTERESTS = "interests";
    public static final String IS_CONNECTED = "isConnected";
    public static final String LANG = "lang";
    public static final String MEMBER_SINCE = "memberSince";
    public static final String NICKNAME = "nickname";
    public static final String PROFILE_URL = "profileUrl";
    public static final String TIME_ZONE = "timeZone";
    public static final String UPDATED = "updated";
    public static final String URI = "uri";

    public YahooProfileDefinition() {
        super(x -> new YahooProfile());
        Arrays.stream(new String[]{ABOUT_ME, FAMILY_NAME, GIVEN_NAME, NICKNAME, TIME_ZONE, URI, AGE_CATEGORY}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.STRING));
        this.primary(IS_CONNECTED, (AttributeConverter)Converters.BOOLEAN);
        this.primary(BIRTH_YEAR, (AttributeConverter)Converters.INTEGER);
        this.primary(LANG, (AttributeConverter)Converters.LOCALE);
        this.primary(DISPLAY_AGE, (AttributeConverter)Converters.INTEGER);
        this.primary(BIRTHDATE, (AttributeConverter)new DateConverter("MM/dd"));
        this.primary(ADDRESSES, new JsonConverter<List<YahooAddress>>(List.class, new TypeReference<List<YahooAddress>>(){}));
        this.primary(DISCLOSURES, new JsonConverter<List<YahooDisclosure>>(List.class, new TypeReference<List<YahooDisclosure>>(){}));
        this.primary(EMAILS, new JsonConverter<List<YahooEmail>>(List.class, new TypeReference<List<YahooEmail>>(){}));
        this.primary(IMAGE, new JsonConverter<YahooImage>(YahooImage.class));
        this.primary(INTERESTS, new JsonConverter<List<YahooInterest>>(List.class, new TypeReference<List<YahooInterest>>(){}));
        this.primary(CREATED, (AttributeConverter)Converters.DATE_TZ_RFC822);
        this.primary(MEMBER_SINCE, (AttributeConverter)Converters.DATE_TZ_RFC822);
        this.primary(UPDATED, (AttributeConverter)Converters.DATE_TZ_RFC822);
        this.primary(PROFILE_URL, (AttributeConverter)Converters.URL);
    }

    @Override
    public String getProfileUrl(OAuth1Token accessToken, OAuth10Configuration configuration) {
        return "https://social.yahooapis.com/v1/me/guid?format=xml";
    }

    @Override
    public YahooProfile extractUserProfile(String body) {
        YahooProfile profile = (YahooProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null && (json = json.get("profile")) != null) {
            profile.setId(ProfileHelper.sanitizeIdentifier((UserProfile)profile, (Object)JsonHelper.getElement(json, "guid")));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json, attribute));
            }
        }
        return profile;
    }
}

