/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.core.model.Verb;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.pac4j.core.profile.converter.AbstractAttributeConverter;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.OAuth20Profile;
import org.pac4j.oauth.profile.generic.GenericOAuth20ProfileDefinition;
import org.pac4j.scribe.builder.api.GenericApi20;

public class GenericOAuth20Client
extends OAuth20Client<OAuth20Profile> {
    private static final Logger LOG = Logger.getLogger(GenericOAuth20Client.class.getName());
    private String authUrl;
    private String tokenUrl;
    private String profileUrl;
    private String profilePath;
    private Verb profileVerb;
    private Map<String, String> profileAttrs;
    private Map<String, String> customParams;
    private Class[] converterClasses;

    @Override
    protected void clientInit() {
        LOG.info("InternalInit");
        GenericApi20 genApi = new GenericApi20(this.authUrl, this.tokenUrl);
        this.configuration.setApi(genApi);
        this.configuration.setCustomParams(this.customParams);
        GenericOAuth20ProfileDefinition profileDefinition = new GenericOAuth20ProfileDefinition();
        profileDefinition.setFirstNodePath(this.profilePath);
        profileDefinition.setProfileVerb(this.profileVerb);
        profileDefinition.setProfileUrl(this.profileUrl);
        if (this.profileAttrs != null) {
            for (Map.Entry<String, String> entry : this.profileAttrs.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                String[] tokens = value.split("\\|");
                if (tokens.length == 2) {
                    profileDefinition.profileAttribute(key, tokens[1], (AttributeConverter<? extends Object>)this.getConverter(tokens[0]));
                    continue;
                }
                if (tokens.length == 1) {
                    profileDefinition.profileAttribute(key, value, null);
                    continue;
                }
                LOG.warning("Ignored incorrect attribute value expressions:" + value);
            }
        }
        this.configuration.setProfileDefinition(profileDefinition);
        super.clientInit();
    }

    private Class[] getConverters() {
        if (this.converterClasses == null) {
            try {
                Class<?> cla;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                for (cla = classLoader.getClass(); cla != ClassLoader.class; cla = cla.getSuperclass()) {
                }
                Field field = cla.getDeclaredField("classes");
                field.setAccessible(true);
                Vector classes = (Vector)field.get(classLoader);
                this.converterClasses = (Class[])classes.stream().filter(x -> AbstractAttributeConverter.class.isAssignableFrom((Class<?>)x) && !Modifier.isAbstract(x.getModifiers())).toArray(Class[]::new);
                return this.converterClasses;
            }
            catch (Exception e) {
                LOG.warning(e.toString());
            }
        }
        return this.converterClasses;
    }

    private AbstractAttributeConverter getConverter(String typeName) {
        try {
            Stream<Class> acceptableConverters = Arrays.stream(this.getConverters()).filter(x -> {
                try {
                    AbstractAttributeConverter converter = (AbstractAttributeConverter)x.newInstance();
                    Method accept = AbstractAttributeConverter.class.getDeclaredMethod("accept", String.class);
                    return (Boolean)accept.invoke((Object)converter, typeName);
                }
                catch (Exception e) {
                    LOG.warning("Ignore type which no parameterless constructor:" + x.getName());
                    return false;
                }
            });
            Class converterClazz = acceptableConverters.findFirst().get();
            return (AbstractAttributeConverter)converterClazz.newInstance();
        }
        catch (Exception e) {
            LOG.warning(e.toString());
            return null;
        }
    }

    public void setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public void setProfileUrl(String profileUrl) {
        this.profileUrl = profileUrl;
    }

    public void setProfileNodePath(String profilePath) {
        this.profilePath = profilePath;
    }

    public void setProfileVerb(Verb profileVerb) {
        this.profileVerb = profileVerb;
    }

    public void setProfileAttrs(Map<String, String> profileAttrsMap) {
        this.profileAttrs = profileAttrsMap;
    }

    public void setCustomParams(Map<String, String> customParamsMap) {
        this.customParams = customParamsMap;
    }
}

