/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.yahoo;

import com.github.scribejava.core.model.OAuth1Token;
import com.github.scribejava.core.model.Verb;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.pac4j.oauth.profile.creator.OAuth10ProfileCreator;
import org.pac4j.oauth.profile.definition.OAuth10ProfileDefinition;
import org.pac4j.oauth.profile.yahoo.YahooProfile;

public class YahooProfileCreator
extends OAuth10ProfileCreator<YahooProfile> {
    public YahooProfileCreator(OAuth10Configuration configuration) {
        super(configuration);
    }

    @Override
    protected YahooProfile retrieveUserProfileFromToken(OAuth1Token accessToken) throws HttpAction {
        OAuth10ProfileDefinition profileDefinition = (OAuth10ProfileDefinition)((OAuth10Configuration)this.configuration).getProfileDefinition();
        String profileUrl = profileDefinition.getProfileUrl(accessToken, this.configuration);
        String body = this.sendRequestForData(accessToken, profileUrl, profileDefinition.getProfileVerb());
        String guid = CommonHelper.substringBetween((String)body, (String)"<value>", (String)"</value>");
        this.logger.debug("guid : {}", (Object)guid);
        if (CommonHelper.isBlank((String)guid)) {
            throw new HttpCommunicationException("Cannot find guid from body : " + body);
        }
        body = this.sendRequestForData(accessToken, "https://social.yahooapis.com/v1/user/" + guid + "/profile?format=json", Verb.GET);
        YahooProfile profile = (YahooProfile)((Object)((OAuth10Configuration)this.configuration).getProfileDefinition().extractUserProfile(body));
        this.addAccessTokenToProfile(profile, accessToken);
        return profile;
    }
}

