/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.core.model.Verb;
import java.util.Map;
import java.util.logging.Logger;
import org.pac4j.core.context.WebContext;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.OAuth20Profile;
import org.pac4j.oauth.profile.generic.GenericOAuth20ProfileDefinition;
import org.pac4j.scribe.builder.api.GenericApi20;

public class GenericOAuth20Client
extends OAuth20Client<OAuth20Profile> {
    private static final Logger LOG = Logger.getLogger(GenericOAuth20Client.class.getName());
    private String authUrl;
    private String tokenUrl;
    private String profileUrl;
    private String profilePath;
    private Verb profileVerb;
    private Map<String, String> profileAttrs;
    private Map<String, String> customParams;

    @Override
    protected void clientInit(WebContext context) {
        LOG.info("InternalInit");
        GenericApi20 genApi = new GenericApi20(this.authUrl, this.tokenUrl);
        this.configuration.setApi(genApi);
        this.configuration.setCustomParams(this.customParams);
        this.setConfiguration(this.configuration);
        GenericOAuth20ProfileDefinition profileDefinition = new GenericOAuth20ProfileDefinition();
        profileDefinition.setFirstNodePath(this.profilePath);
        profileDefinition.setProfileVerb(this.profileVerb);
        profileDefinition.setProfileUrl(this.profileUrl);
        if (this.profileAttrs != null) {
            for (Map.Entry<String, String> entry : this.profileAttrs.entrySet()) {
                profileDefinition.profileAttribute(entry.getKey(), entry.getValue(), null);
            }
        }
        this.configuration.setProfileDefinition(profileDefinition);
        super.clientInit(context);
    }

    public void setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public void setProfileUrl(String profileUrl) {
        this.profileUrl = profileUrl;
    }

    public void setProfileNodePath(String profilePath) {
        this.profilePath = profilePath;
    }

    public void setProfileVerb(Verb profileVerb) {
        this.profileVerb = profileVerb;
    }

    public void setProfileAttrs(Map<String, String> profileAttrsMap) {
        this.profileAttrs = profileAttrsMap;
    }

    public void setCustomParams(Map<String, String> customParamsMap) {
        this.customParams = customParamsMap;
    }
}

