/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.mongo.profile.service;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.password.PasswordEncoder;
import org.pac4j.core.profile.definition.CommonProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.profile.service.AbstractProfileService;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.mongo.profile.MongoProfile;

public class MongoProfileService
extends AbstractProfileService<MongoProfile> {
    private MongoClient mongoClient;
    private String usersDatabase = "users";
    private String usersCollection = "users";

    public MongoProfileService() {
    }

    public MongoProfileService(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public MongoProfileService(MongoClient mongoClient, String attributes) {
        this.mongoClient = mongoClient;
        this.setAttributes(attributes);
    }

    public MongoProfileService(MongoClient mongoClient, String attributes, PasswordEncoder passwordEncoder) {
        this.mongoClient = mongoClient;
        this.setAttributes(attributes);
        this.setPasswordEncoder(passwordEncoder);
    }

    public MongoProfileService(MongoClient mongoClient, PasswordEncoder passwordEncoder) {
        this.mongoClient = mongoClient;
        this.setPasswordEncoder(passwordEncoder);
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull((String)"passwordEncoder", (Object)this.getPasswordEncoder());
        CommonHelper.assertNotNull((String)"mongoClient", (Object)this.mongoClient);
        CommonHelper.assertNotBlank((String)"usersDatabase", (String)this.usersDatabase);
        CommonHelper.assertNotBlank((String)"usersCollection", (String)this.usersCollection);
        this.defaultProfileDefinition((ProfileDefinition)new CommonProfileDefinition(x -> new MongoProfile()));
        super.internalInit(context);
    }

    protected void insert(Map<String, Object> attributes) {
        Document doc = new Document();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            doc.append(entry.getKey(), entry.getValue());
        }
        this.logger.debug("Insert doc: {}", (Object)doc);
        this.getCollection().insertOne((Object)doc);
    }

    protected void update(Map<String, Object> attributes) {
        String id = null;
        Document doc = new Document();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if ("id".equals(name)) {
                id = (String)value;
                continue;
            }
            doc.append(entry.getKey(), entry.getValue());
        }
        CommonHelper.assertNotNull((String)"id", id);
        this.logger.debug("Updating id: {} with doc: {}", id, (Object)doc);
        this.getCollection().updateOne(Filters.eq((String)"id", id), (Bson)new Document("$set", (Object)doc));
    }

    protected void deleteById(String id) {
        this.logger.debug("Delete id: {}", (Object)id);
        this.getCollection().deleteOne(Filters.eq((String)"id", (Object)id));
    }

    protected List<Map<String, Object>> read(List<String> names, String key, String value) {
        this.logger.debug("Reading key / value: {} / {}", (Object)key, (Object)value);
        ArrayList<Map<String, Object>> listAttributes = new ArrayList<Map<String, Object>>();
        try (MongoCursor cursor = this.getCollection().find(Filters.eq((String)key, (Object)value)).iterator();){
            for (int i = 0; cursor.hasNext() && i <= 2; ++i) {
                Document result = (Document)cursor.next();
                HashMap newAttributes = new HashMap();
                for (Map.Entry entry : result.entrySet()) {
                    String name = (String)entry.getKey();
                    if (names != null && !names.contains(name)) continue;
                    newAttributes.put(name, entry.getValue());
                }
                listAttributes.add(newAttributes);
            }
        }
        this.logger.debug("Found: ", listAttributes);
        return listAttributes;
    }

    protected MongoCollection<Document> getCollection() {
        MongoDatabase db = this.mongoClient.getDatabase(this.usersDatabase);
        return db.getCollection(this.usersCollection);
    }

    public String getUsersDatabase() {
        return this.usersDatabase;
    }

    public void setUsersDatabase(String usersDatabase) {
        this.usersDatabase = usersDatabase;
    }

    public String getUsersCollection() {
        return this.usersCollection;
    }

    public void setUsersCollection(String usersCollection) {
        this.usersCollection = usersCollection;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public void setMongoClient(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"mongoClient", this.mongoClient, "usersCollection", this.usersCollection, "passwordEncoder", this.getPasswordEncoder(), "usersDatabase", this.usersDatabase, "attributes", this.getAttributes(), "profileDefinition", this.getProfileDefinition(), "idAttribute", this.getIdAttribute(), "usernameAttribute", this.getUsernameAttribute(), "passwordAttribute", this.getPasswordAttribute()});
    }
}

