/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jwt.profile;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import java.util.Date;
import java.util.Map;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.jwt.config.encryption.EncryptionConfiguration;
import org.pac4j.jwt.config.signature.SignatureConfiguration;

public class JwtGenerator<U extends CommonProfile> {
    public static final String INTERNAL_ROLES = "$int_roles";
    public static final String INTERNAL_PERMISSIONS = "$int_perms";
    private SignatureConfiguration signatureConfiguration;
    private EncryptionConfiguration encryptionConfiguration;
    private Date expirationTime;

    public JwtGenerator() {
    }

    public JwtGenerator(SignatureConfiguration signatureConfiguration) {
        this.signatureConfiguration = signatureConfiguration;
    }

    public JwtGenerator(SignatureConfiguration signatureConfiguration, EncryptionConfiguration encryptionConfiguration) {
        this.signatureConfiguration = signatureConfiguration;
        this.encryptionConfiguration = encryptionConfiguration;
    }

    public String generate(Map<String, Object> claims) {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        for (Map.Entry<String, Object> entry : claims.entrySet()) {
            builder.claim(entry.getKey(), entry.getValue());
        }
        if (this.expirationTime != null) {
            builder.expirationTime(this.expirationTime);
        }
        return this.internalGenerate(builder.build());
    }

    public String generate(U profile) {
        this.verifyProfile(profile);
        return this.internalGenerate(this.buildJwtClaimsSet(profile));
    }

    protected String internalGenerate(JWTClaimsSet claimsSet) {
        Object jwt = this.signatureConfiguration == null ? new PlainJWT(claimsSet) : this.signatureConfiguration.sign(claimsSet);
        if (this.encryptionConfiguration != null) {
            return this.encryptionConfiguration.encrypt((JWT)jwt);
        }
        return jwt.serialize();
    }

    protected void verifyProfile(U profile) {
        CommonHelper.assertNotNull((String)"profile", profile);
        CommonHelper.assertNull((String)"profile.sub", (Object)profile.getAttribute("sub"));
        CommonHelper.assertNull((String)INTERNAL_ROLES, (Object)profile.getAttribute(INTERNAL_ROLES));
        CommonHelper.assertNull((String)INTERNAL_PERMISSIONS, (Object)profile.getAttribute(INTERNAL_PERMISSIONS));
    }

    protected JWTClaimsSet buildJwtClaimsSet(U profile) {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().subject(profile.getTypedId()).issueTime(new Date());
        if (this.expirationTime != null) {
            builder.expirationTime(this.expirationTime);
        }
        Map attributes = profile.getAttributes();
        for (Map.Entry entry : attributes.entrySet()) {
            builder.claim((String)entry.getKey(), entry.getValue());
        }
        builder.claim(INTERNAL_ROLES, (Object)profile.getRoles());
        builder.claim(INTERNAL_PERMISSIONS, (Object)profile.getPermissions());
        return builder.build();
    }

    public SignatureConfiguration getSignatureConfiguration() {
        return this.signatureConfiguration;
    }

    public void setSignatureConfiguration(SignatureConfiguration signatureConfiguration) {
        this.signatureConfiguration = signatureConfiguration;
    }

    public EncryptionConfiguration getEncryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public void setEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
        this.encryptionConfiguration = encryptionConfiguration;
    }

    public Date getExpirationTime() {
        return new Date(this.expirationTime.getTime());
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = new Date(expirationTime.getTime());
    }

    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), (Object[])new Object[]{"signatureConfiguration", this.signatureConfiguration, "encryptionConfiguration", this.encryptionConfiguration});
    }
}

