/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.direct;

import java.util.Optional;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.BearerAuthExtractor;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;

public class DirectBearerAuthClient
extends DirectClient {
    private String realmName = "authentication required";

    public DirectBearerAuthClient() {
    }

    public DirectBearerAuthClient(Authenticator tokenAuthenticator) {
        this.defaultAuthenticator(tokenAuthenticator);
    }

    public DirectBearerAuthClient(ProfileCreator profileCreator) {
        this.defaultAuthenticator(Authenticator.ALWAYS_VALIDATE);
        this.defaultProfileCreator(profileCreator);
    }

    public DirectBearerAuthClient(Authenticator tokenAuthenticator, ProfileCreator profileCreator) {
        this.defaultAuthenticator(tokenAuthenticator);
        this.defaultProfileCreator(profileCreator);
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotBlank((String)"realmName", (String)this.realmName);
        this.defaultCredentialsExtractor((CredentialsExtractor)new BearerAuthExtractor());
    }

    protected Optional<Credentials> retrieveCredentials(WebContext context, SessionStore sessionStore) {
        context.setResponseHeader("WWW-Authenticate", "Bearer realm=\"" + this.realmName + "\"");
        return super.retrieveCredentials(context, sessionStore);
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "authorizationGenerators", this.getAuthorizationGenerators(), "realmName", this.realmName});
    }
}

