/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.indirect;

import java.util.Optional;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.BasicAuthExtractor;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;

public class IndirectBasicAuthClient
extends IndirectClient {
    private String realmName = "authentication required";

    public IndirectBasicAuthClient() {
    }

    public IndirectBasicAuthClient(Authenticator usernamePasswordAuthenticator) {
        this.defaultAuthenticator(usernamePasswordAuthenticator);
    }

    public IndirectBasicAuthClient(String realmName, Authenticator usernamePasswordAuthenticator) {
        this.realmName = realmName;
        this.defaultAuthenticator(usernamePasswordAuthenticator);
    }

    public IndirectBasicAuthClient(Authenticator usernamePasswordAuthenticator, ProfileCreator profileCreator) {
        this.defaultAuthenticator(usernamePasswordAuthenticator);
        this.defaultProfileCreator(profileCreator);
    }

    protected void internalInit() {
        CommonHelper.assertNotBlank((String)"realmName", (String)this.realmName);
        this.defaultRedirectionActionBuilder((webContext, sessionStore) -> Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)webContext, (String)this.computeFinalCallbackUrl(webContext))));
        this.defaultCredentialsExtractor((CredentialsExtractor)new BasicAuthExtractor());
    }

    protected Optional<Credentials> retrieveCredentials(WebContext context, SessionStore sessionStore) {
        Optional credentials;
        CommonHelper.assertNotNull((String)"credentialsExtractor", (Object)this.getCredentialsExtractor());
        CommonHelper.assertNotNull((String)"authenticator", (Object)this.getAuthenticator());
        context.setResponseHeader("WWW-Authenticate", "Basic realm=\"" + this.realmName + "\"");
        try {
            credentials = this.getCredentialsExtractor().extract(context, sessionStore);
            this.logger.debug("credentials : {}", (Object)credentials);
            if (!credentials.isPresent()) {
                throw HttpActionHelper.buildUnauthenticatedAction((WebContext)context);
            }
            this.getAuthenticator().validate((Credentials)credentials.get(), context, sessionStore);
        }
        catch (CredentialsException e) {
            throw HttpActionHelper.buildUnauthenticatedAction((WebContext)context);
        }
        return credentials;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "callbackUrl", this.callbackUrl, "callbackUrlResolver", this.callbackUrlResolver, "ajaxRequestResolver", this.getAjaxRequestResolver(), "redirectionActionBuilder", this.getRedirectionActionBuilder(), "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "logoutActionBuilder", this.getLogoutActionBuilder(), "authorizationGenerators", this.getAuthorizationGenerators(), "realmName", this.realmName});
    }
}

